# CVE-2025-70829: Information Exposure in Datart

[中文文档](README_CN.md)

## 1. Vulnerability Overview

**CVE ID**: CVE-2025-70829  
**Product**: Datart  
**Version**: v1.0.0-rc.3  
**Vulnerability Type**: Information Exposure

An information exposure vulnerability in Datart v1.0.0-rc.3 allows authenticated attackers to access sensitive data via a custom H2 JDBC connection string. By guiding the application to connect to its own internal database file, attackers can query system tables containing user credentials and configuration details.

---

## 2. Reproduction Steps

### Pre-requisites

- Authenticated access to the Datart dashboard.

### Steps

1. **Log in** to the Datart system (v1.0.0-rc.3).
2. Navigate to the **"Data Source"** section.
3. Click to **create a new source** and select the type **"H2"**.
4. In the configuration, enter the following malicious JDBC URL to point to the local internal database file:
   ```text
   jdbc:h2:file:./bin/h2/datart.demo;MODE=MySQL
   ```
5. Click **"Test Connection"** to confirm access to the internal system database.
6. Save the data source.
7. Use the SQL editor (or create a chart using this source) to execute arbitrary queries.

---

## 3. Sensitive Information Retrieval

### Dump User Credentials & Forge JWT

By retrieving the user's password hash from the database, attackers can forge a valid JWT token to impersonate any user (e.g., administrator). This is because the application uses a hardcoded secret key (`d@a$t%a^r&a*t`) and includes the password hash's Java `hashCode()` in the token payload.

**SQL Query:**

```sql
SELECT id, username, email, password, name FROM user;
```

> **Exploitation**: Use the retrieved `password` hash with `jwttest.py` to generate a valid `Bearer` token for arbitrary user login.

### Dump & Decrypt Data Sources

Attackers can also retrieve configuration for other connected data sources.

**SQL Query:**

```sql
SELECT * FROM source;
```

**Decryption:**

The `config` field in the `source` table is often encrypted using AES. The application uses a default hardcoded security key:

> **Default Security Key**: `d@a$t%a^r&a*t`

You can use the provided [Decrypt.java](Decrypt.java) utility (which includes this default key) to decrypt these values and obtain cleartext credentials for external databases.
