# CVE‑2025‑6907 SQLi Exploit Tool

**File:** `exploit.c`  
**Author:** Byte Reaper  
**Target Service:** CODE_PROJECT  
**Type:** SQL Injection  

---

## 🔎 Overview

This is a standalone C-based SQL Injection exploit targeting the **CVE‑2025‑6907** vulnerability in the **CODE_PROJECT** service.  
It combines multiple advanced techniques:

- Automated payload enumeration (including Boolean- and Time‑based checks)  
- Inline assembly syscalls for directory/process inspection  
- Memory‑mapping dump (`/proc/self/maps`)  
- Rotating User‑Agent strings  
- Optional environment checks (files, folders, Apache)  
- Detailed verbose output and payload address mapping  

---

## ⚙️ Features

- **Partial & Full URL modes** (`-u / --url`, `-i / --input`)  
- **Show HTTP responses** (`-r / --response`)  
- **Environment checks** (`-c / --check`)  
- **Verbose mode** (`-v / --verbose`):  
  - Detailed `curl` logs  
  - Payload pointer & length printouts  
  - Memory map dump  
- **Help page** (`-h / --help`) with full argument explanations  

---

## 🛠️ Prerequisites

- Linux x86_64  
- `gcc`, `make`  
- `libcurl` development headers  
- `argparse.h` (C argument‑parser header)  

---

## 📥 Installation

# Build
gcc exploit.c argparse.c -o exploit -lcurl
🚀 Usage

./exploit [options]
Arguments
Short Long  Description
-h  --help  Show detailed help and exit.
-u  --url Base URL (partial). Appends payloads to book_car.php?fname= by default.
-i  --input Treat provided URL as full (including query).
-r  --response  Print HTTP response bodies for each payload attempt.
-c  --check Perform environment checks (files, folders, Apache processes).
-v  --verbose Enable verbose logs, payload address mapping, and memory map dump.

Examples
Basic scan

./exploit -u http://127.0.0.1
Show server responses


./exploit -u http://127.0.0.1 -r
Full‑URI mode

./exploit -u "http://127.0.0.1
Environment & Apache check
sudo ./exploit -c
Verbose with memory map

sudo ./exploit -i http://127.0.0.1/book_car.php?fname= -v
OR 
sudo ./exploit -i http://127.0.0.1/folder/file.php?fname= 
🧩 How It Works
Startup checks

Ensures running on Linux

Requires root for some operations (memory map, directory syscalls)

Argument parsing

Uses argparse.h to handle flags and options

Environment inspection (-c)

Scans /var/www/html for known CODE_PROJECT folders

Lists and classifies important PHP files

Checks/runs Apache service

Payload injection loop

Iterates a list of SQL strings (boolean, UNION, time‑based…)

URL‑encodes and sends via libcurl

Detects SQLi via response signatures or time delays

Advanced logging (-v)

Prints each payload’s memory address and length

Dumps /proc/self/maps memory regions

⚠️ Disclaimer
For authorized testing only. Do NOT use against systems you do not own or have explicit permission to test.

Use responsibly and ethically.

📜 License
This work is provided “as-is” without warranty of any kind. Use at your own risk.

