# CVE-2025-68926 - RustFS Hardcoded gRPC Authentication Token

## Description

RustFS versions < 1.0.0-alpha.77 contain a hardcoded gRPC authentication token (`"rustfs rpc"`) that allows unauthenticated access to all gRPC services.

## Vulnerability Details

- **CVE**: CVE-2025-68926
- **Affected Versions**: < 1.0.0-alpha.77
- **Hardcoded Token**: `"rustfs rpc"`
- **Impact**: Unauthenticated file read/write operations and system information disclosure

## Setup

```bash
# Install dependencies
go mod download

# Build
go build -o exploit main.go

# Launch lab
docker compose up -d
```

## Usage

```bash
./exploit <host> <port>
```

Example:
```bash
./exploit localhost 19010
```

## References

- `rustfs/src/server/http.rs:651`
- `crates/protos/src/lib.rs:111`
