# CVE-2025-68860
WordPress Mobile builder Plugin &lt;= 1.4.2 is vulnerable to a high priority Broken Authentication

# 🚨 WordPress Mobile builder Plugin <= 1.4.2 - Broken Authentication Exploit (CVE-2025-68860)

## 📝 Overview

**WordPress Mobile builder Plugin** versions <= **1.4.2** are vulnerable to a high priority Broken Authentication issue.  
**CVE:** [CVE-2025-68860](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-68860)

---

### 🛡️ Description

> **Authentication Bypass Using an Alternate Path or Channel** vulnerability in Mobile Builder allows Authentication Abuse. This issue affects Mobile builder from n/a through 1.4.2.

- **CVSS Score:** 9.8 CRITICAL  
- **Vector:** AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H

A remote attacker can craft a valid authentication token and gain administrator access without any prior interaction or credentials, leading to full compromise of the WordPress installation.

---

## ⚙️ Script Description

**CVE-2025-68860.py** is a fully automated exploit for the WordPress Mobile builder <= 1.4.2 Authentication Bypass vulnerability.  
On execution, the script:

- Ignores all prior states, resets any previous workflow, and only targets the current CVE vector.
- Generates a valid JWT token as admin (`user_id=1`) with a known static secret.
- Authenticates to the `/wp-json/wp/v2/users/me` endpoint to confirm administrator access.
- Proceeds to create a new administrator account:
  - Username: `Nxploited`
  - Password: `admin`
  - Email:    `adminnx@admin.com`
- Prints the new admin credentials in a clear, separate, and professional manner.
- Outputs the full API response for successful account creation.
- Shows colorized and structured output for each stage.

---

## 🌟 Key Features

- **No Manual Steps:** Completely automated, single-step exploitation.
- **State Isolation:** Ignores all previous exploits, accounts, or environment variables. Only this logic is used.
- **Credential Extraction:** Clearly displays newly created admin credentials; no need to search API responses.
- **Full API Output:** Shows the WordPress REST API response for full transparency.
- **Colorized Terminal UI:** Professional, easy-to-read output for high-confidence exploitation.
- **Resilient Routine:** Handles most edge cases and errors with clear user feedback.

---

## 🎯 Script Name

`CVE-2025-68860.py`

---

## 🚀 Usage

```bash
python3 CVE-2025-68860.py
```

---

## 📦 Requirements

- Python 3.7+
- python modules:  
  - `pyjwt`
  - `requests`
  - `colorama`
- Install dependencies (if needed) via:
  ```bash
  pip3 install pyjwt requests colorama
  ```

---

## 🖨️ Output

Upon execution and successful exploitation, you will get:

- New admin credentials (highlighted) for immediate use:
  ```
  Username : Nxploited
  Password : admin
  Email    : adminnx@admin.com
  ```
- Full REST API response (JSON) of the new user.
- Clear status and colorized feedback for each step.

---

## ⚠️ Disclaimer

> This script is provided for educational and authorized testing purposes only.  
> **Do not use it against systems you do not own or have explicit, legal authorization to test.**  
> Any misuse may be illegal and is solely the user’s responsibility.

---

**By:** Nxploited (Khaled Alenazi)  
**Telegram:** [@KNxploited](https://t.me/KNxploited)  
**GitHub:** [https://github.com/Nxploited](https://github.com/Nxploited)
