const express = require('express');
const { jsPDF } = require('jspdf/dist/jspdf.node.min.js');
const fs = require('fs');
const path = require('path');

const app = express();
const PORT = 8080;

app.get('/api/v1/generate-invoice', (req, res) => {
    const clientName = req.query.client || 'Unknown Client';
    
    const brandingPath = req.query.branding;

    console.log(`[INFO] Generating invoice for: ${clientName}`);
    console.log(`[INFO] Loading branding asset from: ${brandingPath}`);

    try {
        const doc = new jsPDF();

        doc.setFontSize(22);
        doc.text(`INVOICE: ${clientName.toUpperCase()}`, 10, 20);
        
        doc.setFontSize(12);
        doc.text(`Date: ${new Date().toISOString()}`, 10, 30);
        doc.text("Service: Security Audit", 10, 40);
        doc.text("Amount Due: $5,000.00", 10, 50);

        if (brandingPath) {
            try {
                doc.addImage(brandingPath, 'JPEG', 150, 10, 40, 40);
            } catch (err) {
                console.error(`[WARN] Failed to render image visually: ${err.message}`);
                doc.text("[Logo Error]", 150, 10);
            }
        }

        const pdfOutput = doc.output('arraybuffer');
        res.setHeader('Content-Type', 'application/pdf');
        res.setHeader('Content-Disposition', `attachment; filename=invoice_${Date.now()}.pdf`);
        res.send(Buffer.from(pdfOutput));

    } catch (error) {
        console.error(`[ERROR] Critical failure: ${error.message}`);
        res.status(500).send("Internal Server Error");
    }
});

app.listen(PORT, () => {
    console.log(`[*] Vulnerable Invoice Service running on http://localhost:${PORT}`);
});
