# CVE-2025-68116

Author: @x0root  
Vulnerability: Stored Cross-Site Scripting (XSS) via Browser-Renderable Uploads (SVG / HTML)  
Affected Software: FileRise (< 2.7.1)  
Patched Version: 2.7.1  
Official CVE (requested via GHSA): CVE-2025-68116 (tracking/advisory: GHSA-35pp-ggh6-c59c)  
Prior related advisory (original mitigation that was bypassed): GHSA-qrcv-vjvf-fr29




CVSS Assessment:
- CNA (GitHub): CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:L — 8.9 (High)
- Reporter (author analysis): CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:L — 9.6 (Critical)

### CVSS Scoring Rationale (Reporter)

The reporter’s assessment evaluates Privileges Required (PR) at the point of
exploitation, not at the point of vulnerability planting.

Exploitation occurs when a victim accesses a generated public share link,
which requires no authentication or privileges (PR:N).

The CNA assessment evaluates PR based on the ability to upload a malicious file.
However, CVSS v3.1 defines Privileges Required (PR) as the privileges an attacker must
possess at the time the vulnerability is exploited, not the privileges required
to place or prepare the vulnerable condition.

As such, PR:N more accurately reflects real-world exploitation conditions,
resulting in a Critical (9.6) severity classification.

> Note: GHSA-qrcv-vjvf-fr29 introduced a mitigation that prevented SVGs from rendering inside the FileRise web UI (preview pane). This report documents a bypass of that mitigation—specifically the backend share/download endpoints—which is tracked as GHSA-35pp-ggh6-c59c / CVE-2025-68116.

---

## Abstract

This document is a complete technical record of CVE-2025-68116: a Stored XSS in FileRise that persisted after an earlier mitigation and was ultimately fixed in v2.7.1. It includes discovery, exploitation proof-of-concepts, repeated failed fixes, a precise root-cause control-flow analysis (with evidence), final verification of the patch, and an analysis of exploitability characteristics relevant to CVSS assessment. All content below is based on reproduced tests, controller inspection, and the public advisory thread.

---

## 1. Background: Prior Advisory and Incomplete Fix

A prior advisory, **GHSA-qrcv-vjvf-fr29**, addressed Stored XSS via SVG uploads by blocking inline rendering in the FileRise web UI. That mitigation did **not** address how SVG files were served by backend endpoints such as:

- `/api/file/download.php`
- `/api/file/share.php`

CVE-2025-68116 (tracked as **GHSA-35pp-ggh6-c59c**) documents a bypass of the GHSA-qrcv-vjvf-fr29 mitigation: an attacker can store a crafted SVG and deliver it to victims via public share links or certain download behaviours, leading to script execution in the FileRise origin.

---

## 2. Discovery: Proof-of-Concept Upload & Bypass

To validate whether the backend still exposed SVGs in a renderable way, I uploaded a simple PoC SVG:

<svg xmlns="http://www.w3.org/2000/svg" onload="alert('XSS: ' + document.domain)"></svg>

Accessing the file via:

- `/api/file/download.php?…`  
and, more importantly, via:
- `/api/file/share.php?token=…`

resulted in `alert()` executing. The original GHSA-qrcv-vjvf-fr29 mitigation (UI preview block) was bypassed by direct access to these endpoints.

---

## 3. Proving Real-World Impact

An `alert()` is a PoC; I tested for meaningful impact by having the payload interact with internal APIs.

Test payload used:

```xml
<svg version="1.1" xmlns="http://www.w3.org/2000/svg">
  <script type="text/javascript">
    fetch('/api/upload/upload.php')
      .then(response => response.text())
      .then(data => alert('API Response: ' + data));
  </script>
</svg>
```


When a logged-in administrator opened a share link containing this SVG, the script executed and made authenticated API requests. Observed effects included:

- API responses returned to the script (sensitive information could be exposed)
- The API response indicated CSRF token state (e.g., `{"csrf_expired":true,"csrf_token":"..."}`)
- The interaction invalidated the administrator's existing CSRF token, preventing further state-changing actions until recovery (practical denial-of-service against admin functions)

Impact classification demonstrated during testing:
- Confidentiality: High (C:H)  
- Integrity: High (I:H)  
- Availability: Low (A:L)

---

## 4. Disclosure Timeline & Repeated Fix Attempts

I reported the issue privately. The maintainer released several incremental fixes:

- **v2.6.0** — Mitigation applied to download endpoint; share endpoint still vulnerable.
- **v2.6.2** — Further attempts; share endpoint remained vulnerable in my tests.
- **v2.7.0** — Claimed hardening for share endpoint; still exploitable in my environment.
- **v2.7.1** — Final fix that I verified resolves the issue (see Verification section).

Throughout v2.6.0 → v2.7.0, the share link endpoint continued to serve the SVG in a way that allowed inline rendering and script execution. The root cause analysis below explains why the earlier fixes failed to fully close the vector.

---

## 5. Root Cause Analysis — Control Flow & Header Failure (Evidence)

The underlying cause was not a single missing header but **control-flow and output ordering** inside `shareFile()` (controller) that prevented the security headers from being applied in many execution paths. Two classes of problems were present:

- Multiple early `exit;` points that short-circuited the function before security headers were set.  
- PHP warnings/notices that emitted output prior to header calls, causing "headers already sent" errors.

### 5.1 Early exit enumeration

I used an `awk` scan to list `header()` and `exit;` occurrences within `shareFile()` up to the `readfile()` call:

Command:
awk '/function shareFile(/ {flag=1} /readfile(/ {flag=0} flag && /(header|exit;)/ {printf "%4d | %s\n", NR, $0}' src/controllers/FileController.php

Observed output (abridged from my run):

1649 | header('Content-Type: application/json; charset=utf-8');
1651 | exit;
1657 | header('Content-Type: application/json; charset=utf-8');
1659 | exit;
1664 | header('Content-Type: application/json; charset=utf-8');
1666 | exit;
1670 | header("Content-Type: text/html; charset=utf-8");
1693 | exit;
1699 | header('Content-Type: application/json; charset=utf-8');
1701 | exit;
1719 | header('Content-Type: application/json; charset=utf-8');
1721 | exit;
1725 | header('Content-Type: application/json; charset=utf-8');
1727 | exit;

Security headers (the hardening logic) begin at line ~1743:

1743 | header('X-Content-Type-Options: nosniff');
...
1770 | header("Content-Disposition: attachment; ...");

Because the function emits headers + `exit;` earlier in many paths, those requests never reached the hardening code that sets `Content-Disposition`, `nosniff`, or the restrictive type.

### 5.2 Password prompt path

In the password-protected share flow, the function emitted the password prompt HTML early:

if (!empty($record['password']) && empty($providedPass)) {
    header("Content-Type: text/html; charset=utf-8");
    ...
    exit;
}

This path sends `Content-Type: text/html` and exits before the SVG hardening logic, causing inline rendering in browsers for password-protected shares where no password was provided.

### 5.3 Non-password-protected shares (demonstrated)

The vulnerability was not limited to password-protected flows. A non-password share request returned `text/html` as well in my tests:

Command:
curl -svI "http://127.0.0.1:8080/api/file/share.php?token=437d7913884ace4b94fab8ce745a686a" 2>&1 | grep -iE "content-type"

Observed:
< Content-Type: text/html; charset=UTF-8

This confirms that even in the general (non-password) case the response was `text/html`, and the SVG rendered inline.

### 5.4 "Headers already sent" due to PHP notices

I captured a raw fetch of the share endpoint which included PHP warnings emitted before header hardening. Snapshot (abridged):

Command:
curl -s "http://127.0.0.1:8080/api/file/share.php?token=437d7913884ace4b94fab8ce745a686a" | head -n 30

Observed raw output (abridged):

Deprecated: Constant FILTER_SANITIZE_STRING is deprecated in
/data/data/com.termux/files/home/FileRise/src/controllers/FileController.php
on line 1644

<br />
<b>Deprecated</b>: Constant FILTER_SANITIZE_STRING is deprecated in
<b>/data/data/com.termux/files/home/FileRise/src/controllers/FileController.php</b>
on line <b>1645</b><br />

<br />
<b>Warning</b>: Cannot modify header information - headers already sent by
(output started at /data/data/com.termux/files/home/FileRise/src/controllers/FileController.php:1644)
in <b>/data/data/com.termux/files/home/FileRise/src/controllers/FileController.php</b>
on line <b>1743</b><br />

<br />
...then the raw SVG payload streamed and rendered inline...

These warnings show that output was produced (deprecated notices) before the header hardening, making it impossible for subsequent header() calls to take effect in those runs.

### 5.5 Summary of root cause

- Hardening code to force downloads and set `nosniff` existed, but was **not reached** on many code paths due to early exits and output.  
- PHP notices/warnings further prevented header modification.  
- The practical result: share links (both password and non-password paths in some cases) returned HTML or otherwise allowed the browser to render SVG inline, executing embedded scripts.

---

## 6. Final Fix (v2.7.1) and Verification

Following the root-cause reports, the maintainer applied changes that addressed the control-flow and output ordering. In v2.7.1:

- SVG/SVGZ share links are forced to download (Content-Disposition: attachment).  
- Files are served with a safe MIME (application/octet-stream) for SVGs.  
- X-Content-Type-Options: nosniff is applied.  
- Security header logic is executed before any output, and earlier `exit;` points that bypassed hardening were corrected/handled.

Final verification (my test on v2.7.1):

Command:
curl -svI "http://127.0.0.1:8080/api/file/share.php?token=fc911e48b0a30e9417a9020ef959784d" 2>&1 | grep -iE "content-type|content-disposition"

Observed:
< Content-Type: application/octet-stream
< Content-Disposition: attachment; filename="xss-image.svg"; filename*=UTF-8''xss-image.svg

Result: Browser forced a download; the SVG did **not** render inline and the XSS payload did not execute. I consider v2.7.1 to have resolved the issue in my environment.

---

## 7. CVSS Exploitability Context

### Exploitability assessment (reporter analysis)
- CVSS evaluates privileges required **at the time of exploitation**, not at planting.  
- Exploit delivery here is unauthenticated: any recipient of a public share link (including admins) can trigger the payload without authentication.  
- This creates a *fire-and-forget* weapon: the attacker plants a malicious file, logs out, and the public share link remains exploitable.  
- Therefore the correct CVSS vector for the **most severe realistic scenario** is:

CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:L — **Score: 9.6 (Critical)**

I documented this rationale in the advisory thread and requested PR:N be used.

### Maintainer assessment (as published)
- The maintainer scored Privileges Required as **Low (PR:L)** on the official advisory, arguing that uploading/planting the malicious file requires an account or an upload-enabled token (a pre-existing capability).  
- They considered that requirement part of pre-exploitation privileges and therefore used PR:L; the advisory text still notes that resulting share URLs can be opened by unauthenticated recipients.

### Administrative outcome
- The maintainer proceeded to request the CVE via GitHub and published the GHSA advisory with PR:L (High 8.9).  
- The CVE was requested via GitHub as part of the GHSA process and published with PR:L. This document preserves the reporter’s technical analysis of exploitability characteristics for completeness and future reference

**The CNA’s CVSS vector reflects a constrained threat model.**

Empirical testing demonstrates a more severe and reproducible exploitation path,
which aligns with a higher CVSS 3.1 base score under standard scoring rules.

Independent raters are encouraged to assess severity using the observed
exploitation conditions described in this document, ensuring the public severity
reflects real-world impact rather than a narrowly scoped baseline.

---

## 8. Conclusion

- The issue was a **true Stored XSS** where SVGs could be served in a way that allowed inline rendering and script execution.  
- The prior advisory (GHSA-qrcv-vjvf-fr29) mitigated preview rendering but did not address the backend share/download endpoints; GHSA-35pp-ggh6-c59c (CVE-2025-68116) documents this bypass.  
- The core technical root cause was control-flow ordering and output-before-headers, which prevented security headers from being applied in multiple execution paths.  
- The final fix in v2.7.1 corrects the control flow, forces downloads for SVGs, and applies appropriate headers; I verified the fix.  
- Different interpretations of CVSS Privileges Required (PR:N vs PR:L) are documented for transparency

---

## Appendix A — Evidence (selected fragments captured during investigation)

### A.1 Early-exit header scan (awk output, abridged)

1649 | header('Content-Type: application/json; charset=utf-8');
1651 | exit;
1657 | header('Content-Type: application/json; charset=utf-8');
1659 | exit;
1664 | header('Content-Type: application/json; charset=utf-8');
1666 | exit;
1670 | header("Content-Type: text/html; charset=utf-8");
1693 | exit;
1699 | header('Content-Type: application/json; charset=utf-8');
1701 | exit;
1719 | header('Content-Type: application/json; charset=utf-8');
1721 | exit;
1725 | header('Content-Type: application/json; charset=utf-8');
1727 | exit;

Security headers start at ~1743:
1743 | header('X-Content-Type-Options: nosniff');
...
1770 | header("Content-Disposition: attachment; ...");

### A.2 Non-password share curl header (vulnerable behavior)

~/FileRise $ curl -svI "http://127.0.0.1:8080/api/file/share.php?token=437d7913884ace4b94fab8ce745a686a" 2>&1 | grep -iE "content-type"
< Content-Type: text/html; charset=UTF-8

### A.3 "Headers already sent" and deprecated notices (raw output sample)

Deprecated: Constant FILTER_SANITIZE_STRING is deprecated in
/data/data/com.termux/files/home/FileRise/src/controllers/FileController.php
on line 1644

<br />
<b>Deprecated</b>: Constant FILTER_SANITIZE_STRING is deprecated in
<b>/data/data/com.termux/files/home/FileRise/src/controllers/FileController.php</b>
on line <b>1645</b><br />

<br />
<b>Warning</b>: Cannot modify header information - headers already sent by
(output started at /data/data/com.termux/files/home/FileRise/src/controllers/FileController.php:1644)
in <b>/data/data/com.termux/files/home/FileRise/src/controllers/FileController.php</b>
on line <b>1743</b><br />

...followed by the SVG payload being printed and rendered inline.

### A.4 Final verification (v2.7.1)

~/FileRise $ curl -svI "http://127.0.0.1:8080/api/file/share.php?token=fc911e48b0a30e9417a9020ef959784d" 2>&1 | grep -iE "content-type|content-disposition"
< Content-Type: application/octet-stream
< Content-Disposition: attachment; filename="xss-image.svg"; filename*=UTF-8''xss-image.svg

---
