# CVE-2025-68055
## Authenticated SQL injection in Hydra Booking Plugin <= 1.1.32

This is just a POC I made for practice after finding this CVE in the recently disclosed list. As of making this POC, this vulnerability is still present in the latest release of Hydra Booking (1.1.32). I am not responsible for any malicious use of this program.

### Description of the vulnerability

Hydra Booking performs improper user input sanitization in multiple SQL-requests in various objects. This script exploits the Booking object by creating or updating a booking with a malicious id. 

Whenever an array type is passed in the `booking->get()` function, Hydra Booking hardcodes user input directly into the raw sql request instead of using **prepare** to sanitize input, leading to Time-Based Blind SQL injection.

### Exploit

A simple run command as such will tell you whether or not the running wordpress instance is vulnerable : 
```
./CVE-2025-68055.py 
    --url <wordpress_host> 
    --login <username> 
    --password <password>

Exploit options : 
    --list-users 
    --dump-password <target>
```

Two options are available in the script as for exploitation but one can modify the script or use tools like **SQLMap** to get more specific data out of the database.

Option 1 : By adding `--list-users` the script will exploit the sql injection to dump every entry of the column `user_login` in the wordpress users table.
Option 2 : By adding `--dump-password <target_user>` the script will dump the password hash of the requested user (if the user exists)
