import requests
import sys

BACKEND_URL = "http://127.0.0.1:5001"

def set_role():
    username = "user"
    try:
        response = requests.post(
            f"{BACKEND_URL}/api/user/role",
            json={"username": username, "role": "normal_user"},
            timeout=5
        )
        if response.status_code == 200:
            print("'role':'normal_user' has been set.")
        else:
            print(f"Error: {response.json()}")
            return 1
    except Exception as e:
        print(f"Error: {e}")
        return 1
    return 0

def get_role():
    username = "user"
    try:
        response = requests.get(
            f"{BACKEND_URL}/api/user/role",
            params={"username": username},
            timeout=5
        )
        if response.status_code == 200:
            data = response.json()
            role = data.get('role')
            print(f"'role':'{role}'")
        else:
            print(f"Error: {response.json()}")
            return 1
    except Exception as e:
        print(f"Error: {e}")
        return 1
    return 0

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: python victim_client.py <set|get>")
        sys.exit(1)

    if sys.argv[1] == "set":
        sys.exit(set_role())
    elif sys.argv[1] == "get":
        sys.exit(get_role())
    else:
        print("Usage: python victim_client.py <set|get>")
        sys.exit(1)
