# CVE-2025-67730 – Stored Cross-Site Scripting (XSS)

## Overview

**CVE ID:** CVE-2025-67730
**Vulnerability Type:** Stored Cross-Site Scripting (XSS)
**Severity:** Medium–High (context-dependent)

This vulnerability allowed authenticated users to inject malicious HTML and JavaScript into **description fields** of **Job**, **Course**, and **Batch** forms. The injected payload would execute automatically in the browser of any user who later viewed the affected Job, Course, or Batch.

---

## Affected Components

* Job description field
* Course description field
* Batch description field

---

## Impact

* Execution of arbitrary JavaScript in victim browsers
* Session hijacking
* Credential theft
* Account takeover (depending on privilege level)
* DOM manipulation and phishing

Because the payload is **stored**, the attack persists and affects every user who views the compromised content.

---

## Attack Scenario

1. Attacker logs in with a valid user account.
2. Attacker creates or edits a Job, Course, or Batch.
3. Malicious JavaScript is inserted into the description field.
4. The payload is saved in the database.
5. Any user opening the affected page triggers the payload.

---

## Proof of Concept (PoC)

```html
"><img src=x onerror=alert(document.domain)>
```

**Steps to Reproduce:**

1. Log in as any authenticated user.
2. Navigate to Job / Course / Batch creation or edit page.
3. Paste the payload into the description field.
4. Save the form.
5. Open the created Job / Course / Batch.
6. JavaScript executes in the browser.

---

## Root Cause

* Missing or insufficient **server-side HTML sanitization**
* Unsafe rendering of user-supplied input
* Lack of output encoding in templates

---

## Fix / Mitigation

### Official Patch

* **Fixed in version:** `2.42.0`

### Security Improvements Implemented

* Proper HTML sanitization on input
* Safe output encoding before rendering
* Restriction of executable tags and attributes

### Recommended Best Practices

* Always sanitize user input on the server side
* Apply output encoding based on context (HTML, JS, URL)
* Use a trusted HTML sanitizer (e.g., DOMPurify)
* Implement Content Security Policy (CSP)

---

## Timeline

* **Reported by:** Dharan Raghunathan
* **Status:** Fixed
* **Patch Release:** Version 2.42.0

---

## Acknowledgement

This issue was responsibly disclosed by **Dharan Raghunathan**.

---

## References

* OWASP Stored XSS: [https://owasp.org/www-community/attacks/xss/](https://owasp.org/www-community/attacks/xss/)
* CWE-79: Improper Neutralization of Input During Web Page Generation
* Github Advisory: [https://github.com/frappe/lms/security/advisories/GHSA-jjc4-j3hw-33h2](https://github.com/frappe/lms/security/advisories/GHSA-jjc4-j3hw-33h2)
---

## Disclaimer

This document is for educational and defensive security purposes only.
