# 🚨 Unauthenticated Remote Code Execution (RCE) via File Upload

## 📌 Overview
- **Project:** QloApps
- **Repository:** https://github.com/Qloapps/QloApps
- **Affected Version(s):** <= 1.7.0
- **Vulnerability Class:** Unauthenticated Remote Code Execution
- **Severity:** Critical
- **CVSS v3.1:** (Critical) 9.8 CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE ID:** CVE-2025-67325
- **Discovered By:** Neakk Pornlur
- **Disclosure Date:** 2026-01-09

---

## 🧩 Description
Unrestricted file upload in the hotel review feature in QloApps versions 1.7.0 and earlier allows remote unauthenticated attackers to achieve **remote code execution**.

---

## 🎯 Affected Endpoint
/module/qlohotelreview/default
---

## ⚠️ Root Cause
The vulnerability exists due to:
- Missing file extension validation.
- Uploaded files being executed directly by the server.
- No authentication or authorization checks enforced on the endpoint.

---

## 🔥 Impact
A successful exploit allows an attacker to:
- Execute arbitrary OS commands.
- Read/write/delete sensitive server files.
- Access database credentials.
- Pivot to internal network services.
- Fully compromise the hosting server.

This vulnerability leads to a **complete loss of Confidentiality, Integrity, and Availability (CIA Triad).**

---

## 🛠️ Proof of Concept (PoC) on QloApps version 1.7.0
We need a valid id_order and Ajax token to request to the vulnerable endpoint. For id_order we manual bruteforce it by start from 1 or we create a guest account and booking a room to get this id_order. For the Ajax token we can get from any hotel room page.

### 1. Getting Ajax Token
<img width="1418" height="628" alt="poc1" src="https://github.com/user-attachments/assets/15bf1b1a-42c5-4b41-b28a-26311463566a" />

### 2. Review a hotel and upload our engineered image+php web shell. 
<img width="668" height="459" alt="poc2" src="https://github.com/user-attachments/assets/631b5c1d-3a43-46b0-8e9f-b05102b84921" />
<img width="461" height="154" alt="poc3" src="https://github.com/user-attachments/assets/f4ca496c-1d50-4bd8-9c30-ef8ca729e8fa" />

### 3. Triggering Remote Code Execution
we can find our uploaded web shell at https://target.com/modules/qlohotelreview/views/img/review/<id_order>/1.php
<img width="1402" height="425" alt="poc" src="https://github.com/user-attachments/assets/5c423c83-8678-4edb-ab9f-8dd30b96aa61" />





