### Finding

Within the ‘LibreNMS’ application, we discovered a reflected Cross-Site Scripting vulnerability; this vulnerability exists in the routing module’s protocol parameter, allowing an attacker to render malicious JavaScript in a victim’s browser.
This vulnerability affects all versions from 22.9.0 (September 2022) through 24.9.1 (September 2024). This vulnerability was silently patched in version 24.10.0 (November 2024) without a subsequent CVE or public disclosure. 
This undocumented fix means many organisations may be unaware of their exposure and are yet to apply necessary updates.
You can see the current setup used to test this vulnerability in the figure below:

![alt text](https://github.com/joelatplay/CVE-2025-66850/blob/main/LibreNMS_Version.png)

### Technical Summary

A reflected Cross-Site Scripting vulnerability allows remote attackers to inject arbitrary JavaScript code in the browsers of authenticated LibreNMS users through specially crafted URLs – 
potentially allowing them to harvest session cookies, create an admin backdoor, or redirect users to attacker-controlled domains. 
Proof of XSS can be seen in the image below:

![alt text](https://github.com/joelatplay/CVE-2025-66850/blob/main/EvidenceForXSS_LibreNMS.png)

The security flaw results from insufficient input validation in the ‘/routing’ endpoint’s ‘protocol’ parameter. The application applies basic sanitisation through the ‘basename()’ attribute, preventing directory traversal but fails to perform HTML entity encoding before reflecting the input on the page – 
allowing attackers to bypass basic security controls and inject malicious code.

### Affected Product Information

Product: LibreNMS <br>
Affected Versions:  <= 24.9.1 <br>
Fixed Version: 24.10.0 (November 5, 2024) <br>
Vulnerability Type: CWE-79 (Improper Neutralization of Input During Web Page Generation) 

### Vulnerable Component

Module: Routing <br>
Endpoint: /routing <br>
Parameter: protocol <br>
File: includes/html/pages/routing.inc.php 

### Steps to Reproduce

Setup LibreNMS 24.9.1 <br>
Navigate to the ‘/routing/protocol=’ endpoint <br>
Inject the payload from the PoC in the section below 

### Working Proof-of-Concept

```http://[librenms-instance]/routing/protocol=<script>alert(‘SecQuest XSS’)<!-->```

### Researcher Information

Discovered by: Joel Olivier, Leo Cook <br>
Organisation: SecQuest <br>
Date of Discovery: November 18, 2025



