# Security Policy

## Responsible Use
This repository contains security research material for **educational purposes only**.

## Purpose
The code and documentation in this repository are intended to:
- Educate cybersecurity professionals about CVE-2025-66516
- Demonstrate the technical nature of XXE vulnerabilities
- Help organizations test their defenses in controlled environments
- Promote responsible security research

## Authorized Testing Only
**You must have explicit written authorization before using this code to test any system.**

Testing without authorization is illegal and violates:
- Computer Fraud and Abuse Act (CFAA)
- Computer Misuse Act
- Similar laws in most jurisdictions

## Reporting Misuse
If you observe misuse of this code or repository, please report it by:
- Opening a GitHub issue (for non-urgent concerns)
- Contacting the repository owner directly
- Reporting to appropriate authorities for serious violations

## Vulnerability Disclosure
If you discover vulnerabilities using techniques described in this repository:

### Apache Tika Vulnerabilities
- **Security Team**: security@apache.org
- Follow Apache's security reporting guidelines
- Do not publicly disclose until patch is available

### Other Vulnerabilities
- Follow responsible disclosure practices
- Contact vendor security teams directly
- Allow reasonable time for patching (typically 90 days)
- Coordinate public disclosure with vendor

## Best Practices for Security Researchers

1. **Authorization**: Always obtain written permission before testing
2. **Scope**: Stay within agreed testing boundaries
3. **Documentation**: Keep detailed records of testing activities
4. **Disclosure**: Follow responsible disclosure timelines
5. **Ethics**: Prioritize defense over exploitation

## Academic Research
If using this POC for academic research:
- Follow your institution's ethical guidelines
- Obtain IRB/ethics board approval if required
- Use only in isolated lab environments
- Cite sources appropriately

## Legal Compliance
Users are responsible for:
- Understanding applicable laws in their jurisdiction
- Obtaining necessary authorizations
- Complying with terms of service
- Accepting liability for their actions

## Contact
For security concerns about this repository:
- Open a GitHub issue
- Tag as "security concern"
- Provide specific details

For general questions about responsible use:
- Review the DISCLAIMER.md file
- Consult with legal counsel if uncertain
- Contact repository owner through GitHub

## Updates
This security policy may be updated periodically. Check back regularly for changes.

**Last Updated**: December 2025
