/*
    * DocumentProcessor.java
    * INSPIRATION: https://www.upwind.io/feed/apache-tika-rce-cve-2025-66516
    * A simple Java program to process uploaded PDF files using Apache Tika,
    * demonstrating the exploitation of CVE-2025-66516 XXE vulnerability.
    *
    * Usage:
    *   Compile: javac -cp tika-app-X.X.X.jar DocumentProcessor.java
    *   Run:     java -cp tika-app-X.X.X.jar:. DocumentProcessor <pdf-file>
    *
    * Note: Replace tika-app-X.X.X.jar with the actual Tika jar file name.
    * DISCLAIMER: This POC code is for educational purposes only. Unauthorized use may violate laws.
    */

// Import Apache Tika main class for document parsing
import org.apache.tika.Tika;
// Import File class for file operations
import java.io.File;

public class DocumentProcessor {
    
    // Method to process uploaded PDF files - simulates typical application usage of Tika
    public void processUpload(File uploadedFile) {
        try {
            // Create Tika instance with DEFAULT configuration (no security hardening)
            // This is the vulnerable pattern - using Tika with default settings
            Tika tika = new Tika();
            
            System.out.println("[*] Processing file: " + uploadedFile.getName());
            System.out.println("[*] File size: " + uploadedFile.length() + " bytes");
            
            // Parse PDF to string - THIS TRIGGERS THE VULNERABILITY
            // Internally: Tika detects PDF → PDFParser → XFAExtractor → XMLReaderUtils (vulnerable in 3.2.1)
            String content = tika.parseToString(uploadedFile);
            
            System.out.println("\n[+] Extracted content:");
            System.out.println("----------------------------------------");
            System.out.println(content);
            System.out.println("----------------------------------------");
            
            // Check if extracted content contains secrets from XXE exploitation
            // In vulnerable version: content will include file contents from &xxe; entity
            if (content.contains("INTERNAL_SERVER_KEY") || content.contains("EXPOSED")) {
                System.out.println("\n[!!!] XXE VULNERABILITY EXPLOITED!");
                System.out.println("[!!!] Secret file content was extracted!");
            } else {
                System.out.println("\n[✓] No sensitive data found in output");
            }
            
        } catch (Exception e) {
            System.err.println("[!] Error: " + e.getMessage());
            e.printStackTrace();
        }
    }
    
    public static void main(String[] args) {
        // Validate command line arguments
        if (args.length < 1) {
            System.err.println("Usage: java -cp tika-app-X.X.X.jar:. DocumentProcessor <pdf-file>");
            System.exit(1);
        }
        
        // Create File object from command line argument
        File uploadedFile = new File(args[0]);
        // Verify file exists before processing
        if (!uploadedFile.exists()) {
            System.err.println("File not found: " + uploadedFile);
            System.exit(1);
        }
        
        // Instantiate processor and execute
        DocumentProcessor processor = new DocumentProcessor();
        processor.processUpload(uploadedFile);
    }
}
