#!/bin/bash

# CVE-2025-66478 Demo Environment Setup Script

echo "=========================================="
echo "CVE-2025-66478 Demo Environment Setup"
echo "=========================================="
echo ""

# Check if Docker is installed
if ! command -v docker &> /dev/null; then
    echo "❌ Error: Docker not found"
    echo "Please install Docker first: https://docs.docker.com/get-docker/"
    exit 1
fi

# Check if Docker Compose is installed
if ! command -v docker-compose &> /dev/null && ! docker compose version &> /dev/null; then
    echo "❌ Error: Docker Compose not found"
    echo "Please install Docker Compose"
    exit 1
fi

echo "✅ Docker environment check passed"

# Check if Docker daemon is running
echo "🔍 Checking Docker daemon status..."
if ! docker info &> /dev/null; then
    echo "❌ Error: Docker daemon is not running"
    echo ""
    echo "Please follow these steps:"
    echo "1. Start Docker Desktop or Docker service"
    echo "2. Wait for Docker to fully start"
    echo "3. Run this script again"
    echo ""
    echo "Linux system startup commands:"
    echo "  sudo systemctl start docker"
    echo "  # or"
    echo "  sudo service docker start"
    exit 1
fi

echo "✅ Docker daemon is running"
echo ""

# Build and start containers
echo "🔨 Building vulnerable Next.js application..."
docker-compose build

if [ $? -ne 0 ]; then
    echo "❌ Build failed"
    exit 1
fi

echo ""
echo "🚀 Starting demo environment..."
docker-compose up -d

if [ $? -ne 0 ]; then
    echo "❌ Startup failed"
    exit 1
fi

echo ""
echo "⏳ Waiting for application to start..."
sleep 5

echo ""
echo "=========================================="
echo "✅ Demo environment started successfully!"
echo "=========================================="
echo ""
echo "📋 Access Information:"
echo "   - Application: http://localhost:3000"
echo "   - RSC Endpoint: http://localhost:3000/_rsc"
echo ""
echo "🧪 Test Commands:"
echo "   node exploit.js http://localhost:3000/_rsc \"echo test\""
echo ""
echo "📊 View Logs:"
echo "   docker-compose logs -f"
echo ""
echo "🛑 Stop Environment:"
echo "   docker-compose down"
echo ""
echo "⚠️  Warning: This environment is for educational and security research purposes only!"
echo "=========================================="

