# CVE-2025-66478 Demo Environment Setup Script (PowerShell)

Write-Host "==========================================" -ForegroundColor Cyan
Write-Host "CVE-2025-66478 Demo Environment Setup" -ForegroundColor Cyan
Write-Host "==========================================" -ForegroundColor Cyan
Write-Host ""

# Check if Docker is installed
try {
    $dockerVersion = docker --version 2>&1
    if ($LASTEXITCODE -ne 0) {
        throw "Docker not found"
    }
    Write-Host "✅ Docker environment check passed" -ForegroundColor Green
} catch {
    Write-Host "❌ Error: Docker not found" -ForegroundColor Red
    Write-Host "Please install Docker Desktop first: https://docs.docker.com/get-docker/" -ForegroundColor Yellow
    exit 1
}

# Check Docker Compose
try {
    $composeVersion = docker compose version 2>&1
    if ($LASTEXITCODE -ne 0) {
        throw "Docker Compose not found"
    }
    Write-Host "✅ Docker Compose check passed" -ForegroundColor Green
} catch {
    Write-Host "❌ Error: Docker Compose not found" -ForegroundColor Red
    exit 1
}

# Check if Docker Desktop is running
Write-Host "🔍 Checking Docker Desktop status..." -ForegroundColor Yellow
try {
    $dockerInfo = docker info 2>&1
    if ($LASTEXITCODE -ne 0) {
        throw "Docker daemon not running"
    }
    Write-Host "✅ Docker Desktop is running" -ForegroundColor Green
} catch {
    Write-Host "❌ Error: Docker Desktop is not running" -ForegroundColor Red
    Write-Host "" -ForegroundColor Yellow
    Write-Host "Please follow these steps:" -ForegroundColor Yellow
    Write-Host "1. Start Docker Desktop application" -ForegroundColor White
    Write-Host "2. Wait for Docker Desktop to fully start (system tray icon stops blinking)" -ForegroundColor White
    Write-Host "3. Run this script again" -ForegroundColor White
    Write-Host "" -ForegroundColor Yellow
    Write-Host "If Docker Desktop is installed but won't start, please check:" -ForegroundColor Yellow
    Write-Host "- Is Docker Desktop properly installed" -ForegroundColor White
    Write-Host "- Does your system meet Docker Desktop requirements" -ForegroundColor White
    Write-Host "- Do you have sufficient system resources" -ForegroundColor White
    exit 1
}

Write-Host ""

# Build and start containers
Write-Host "🔨 Building vulnerable Next.js application..." -ForegroundColor Yellow
docker-compose build

if ($LASTEXITCODE -ne 0) {
    Write-Host "❌ Build failed" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "🚀 Starting demo environment..." -ForegroundColor Yellow
docker-compose up -d

if ($LASTEXITCODE -ne 0) {
    Write-Host "❌ Startup failed" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "⏳ Waiting for application to start..." -ForegroundColor Yellow
Start-Sleep -Seconds 5

Write-Host ""
Write-Host "==========================================" -ForegroundColor Cyan
Write-Host "✅ Demo environment started successfully!" -ForegroundColor Green
Write-Host "==========================================" -ForegroundColor Cyan
Write-Host ""
Write-Host "📋 Access Information:" -ForegroundColor Cyan
Write-Host "   - Application: http://localhost:3000" -ForegroundColor White
Write-Host "   - RSC Endpoint: http://localhost:3000/_rsc" -ForegroundColor White
Write-Host ""
Write-Host "🧪 Test Commands:" -ForegroundColor Cyan
Write-Host "   node exploit.js http://localhost:3000/_rsc `"echo test`"" -ForegroundColor White
Write-Host ""
Write-Host "📊 View Logs:" -ForegroundColor Cyan
Write-Host "   docker-compose logs -f" -ForegroundColor White
Write-Host ""
Write-Host "🛑 Stop Environment:" -ForegroundColor Cyan
Write-Host "   docker-compose down" -ForegroundColor White
Write-Host ""
Write-Host "⚠️  Warning: This environment is for educational and security research purposes only!" -ForegroundColor Yellow
Write-Host "==========================================" -ForegroundColor Cyan

