# CVE-2025-66478 Proof of Concept

<details><summary>中文版本 / Chinese Version</summary>

## 漏洞概述

**CVE-2025-66478** 是一个影响 Next.js 应用程序的严重远程代码执行 (RCE) 漏洞，源于 React Server Components (RSC) 协议中的不安全反序列化问题。该漏洞的 CVSS 评分为 **10.0**（最高级别），允许未经身份验证的攻击者通过特制的 HTTP 请求在易受攻击的服务器上执行任意代码。

## 技术细节

### 漏洞根源

该漏洞源于上游 React 实现中的不安全反序列化逻辑（CVE-2025-55182），并影响使用 App Router 的 Next.js 应用程序。问题出在 React Server Components 的 "Flight" 协议中，该协议负责在服务器和客户端之间序列化和反序列化数据。

### 影响范围

**受影响的 Next.js 版本：**
- Next.js 15.x
- Next.js 16.x
- Next.js 14.3.0-canary.77 及更高版本的 canary 版本

**不受影响的版本：**
- Next.js 13.x
- Next.js 14.x 稳定版
- 使用 Pages Router 的应用程序
- Edge Runtime

### 攻击向量

攻击者只需向目标服务器发送一个特制的 HTTP 请求，其中包含恶意构造的 RSC payload。当服务器处理这个 payload 时，由于不安全的反序列化逻辑，攻击者控制的数据可以影响服务器端的执行流程，导致任意 JavaScript 代码的执行。

### 受影响的应用

**特别关注：** Dify 等 AI 工具成为重灾区，利用成功率较高。这些应用通常使用 Next.js App Router 和 Server Components，因此容易受到此漏洞影响。

**常见受影响应用类型：**
- Dify 等 AI 应用平台
- 使用 Next.js 15.x/16.x 的 Web 应用
- 使用 App Router 的 Next.js 应用
- 使用 React Server Components 的应用

## Proof of Concept

### 免责声明

**此工具仅用于教育目的和安全研究。** 请勿在未经授权的系统上使用。使用此工具进行任何非法活动均与作者无关。

### 概念验证脚本

`exploit.js` 是一个概念验证脚本，演示了如何构造和发送恶意的 RSC payload。这个脚本包含以下功能：

1. **生成恶意 payload**：构造利用反序列化漏洞的 RSC payload
2. **发送攻击请求**：将恶意 payload 发送到目标服务器
3. **漏洞扫描**：扫描目标应用程序中可能存在漏洞的 RSC 端点

### 使用方法

#### 基本用法

```bash
# 执行特定命令
node exploit.js <目标URL> <命令>

# 示例
node exploit.js http://localhost:3000 "whoami"
```

#### 扫描模式

```bash
# 扫描目标应用程序中的 RSC 端点
node exploit.js <目标URL> --scan

# 示例
node exploit.js http://localhost:3000 --scan
```

## Docker 演示环境

为了安全地演示和测试此漏洞，我们提供了一个完整的 Docker 演示环境，包含一个易受攻击的 Next.js 应用程序。

### 前置要求

- Docker 和 Docker Compose
- 至少 2GB 可用磁盘空间
- 至少 1GB 可用内存

### 快速启动

#### 方法 1: 使用启动脚本（推荐）

**Windows (PowerShell):**
```powershell
.\setup-demo.ps1
```

**Linux/macOS:**
```bash
chmod +x setup-demo.sh
./setup-demo.sh
```

#### 方法 2: 手动启动

```bash
# 1. 构建 Docker 镜像
docker-compose build

# 2. 启动容器
docker-compose up -d

# 3. 查看日志（可选）
docker-compose logs -f
```

### 访问应用

启动后，等待几秒钟，然后访问：

- **应用主页**: http://localhost:3000
- **RSC 端点**: http://localhost:3000/_rsc

### 测试漏洞

使用提供的 exploit 脚本测试漏洞：

```bash
# 基本测试
node exploit.js http://localhost:3000/_rsc "echo test"

# 执行命令
node exploit.js http://localhost:3000/_rsc "whoami"

# 扫描端点
node exploit.js http://localhost:3000 --scan
```

### 环境信息

演示环境包含：

- **Next.js**: 15.0.4 (易受攻击版本)
- **React**: 19.0.0
- **Node.js**: 20 (Alpine Linux)
- **架构**: 使用 App Router 和 Server Components

### 管理命令

```bash
# 查看日志
docker-compose logs -f

# 停止环境
docker-compose down

# 停止并删除数据
docker-compose down -v

# 重启环境
docker-compose restart
```

### 安全注意事项

⚠️ **重要警告**:

1. **仅用于教育目的**: 此环境仅用于学习和安全研究
2. **隔离环境**: 容器运行在隔离的网络中，但仍需谨慎
3. **不要暴露到公网**: 不要将端口映射到公网 IP
4. **及时清理**: 测试完成后及时停止和删除容器
5. **不要在生产环境使用**: 此配置包含已知的安全漏洞

## 测试工具

`test-vulnerability.js` 是一个用于检测应用程序是否受此漏洞影响的工具。它会执行以下检查：

1. **版本检查**：验证 Next.js 版本是否在受影响范围内
2. **端点测试**：检查应用程序中可能存在漏洞的 RSC 端点
3. **漏洞验证**：使用安全的 payload 测试漏洞是否存在

### 使用方法

```bash
# 测试目标应用程序
node test-vulnerability.js <目标URL>

# 示例
node test-vulnerability.js http://localhost:3000
```

## 修复措施

### 立即修复

1. **升级 Next.js**：将 Next.js 升级到最新版本，该版本已修复此漏洞

   ```bash
   npm install next@latest
   # 或
   yarn upgrade next@latest
   # 或
   pnpm update next@latest
   ```

2. **验证修复**：使用 `test-vulnerability.js` 工具验证修复是否成功

   ```bash
   node test-vulnerability.js <目标URL>
   ```

### 临时缓解措施

如果无法立即升级，可以考虑以下临时缓解措施：

1. **使用 Pages Router**：将受影响的路由迁移到 Pages Router，该路由不受此漏洞影响
2. **启用 Edge Runtime**：为受影响的路由启用 Edge Runtime，该运行时不受此漏洞影响

   ```javascript
   // 在页面组件或布局中
   export const runtime = 'edge';
   ```

## 技术细节

### 漏洞原理

该漏洞利用了 React Server Components "Flight" 协议中的不安全反序列化逻辑。当服务器接收到客户端发送的 RSC 请求时，它会反序列化包含组件数据的 payload。由于反序列化过程中缺乏充分的验证，攻击者可以构造恶意 payload，导致服务器执行任意 JavaScript 代码。

### 漏洞利用条件

要利用此漏洞，攻击者需要满足以下条件：

1. 目标应用程序使用 Next.js 15.x、16.x 或 14.3.0-canary.77 及更高版本
2. 目标应用程序使用 App Router
3. 攻击者可以向目标服务器发送 HTTP 请求

### 漏洞影响

成功利用此漏洞可以导致：

1. 远程代码执行 (RCE)
2. 服务器完全控制
3. 数据泄露
4. 服务中断

## 目标发现

### FOFA 搜索语法

```bash
# 搜索 Next.js 应用（通用）
body="NEXT_DATA" && body="version"

# 搜索 AI 相关应用（Dify 等）
body="NEXT_DATA" && (body="AI" || body="人工智能" || body="大模型" || body="LLM")

# 搜索 Dify 应用
body="NEXT_DATA" && (body="dify" || title="Dify" || body="dify.ai")

# 组合搜索
body="NEXT_DATA" && (body="AI" || body="人工智能") && domain="edu.cn"
```

### Hunter 搜索语法

```bash
# 搜索教育机构中的 Next.js 应用
(web.title="Next.js" OR web.body="NEXT_DATA") && domain="edu.cn"
```

### 常见易受攻击端点

- `/_rsc` - React Server Components 端点
- `/api/rsc` - API RSC 端点
- `/api/chat` - Dify 等 AI 工具的聊天端点
- `/api/completion` - 完成端点
- `/api/v1/chat` - API v1 聊天端点
- `/server-actions` - Server Actions 端点

## 参考资料

- [Next.js 安全公告](https://nextjs.org/security)
- [React Server Components 文档](https://react.dev/blog/2020/12/21/data-fetching-with-react-server-components)
- [CVE-2025-55182 详细信息](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-55182)
- [CVE-2025-55182 利用工具参考](https://github.com/Spritualkb/CVE-2025-55182-exp)

</details>

## Vulnerability Overview

**CVE-2025-66478** is a critical Remote Code Execution (RCE) vulnerability affecting Next.js applications, stemming from insecure deserialization in the React Server Components (RSC) protocol. With a CVSS score of **10.0** (the highest possible), it allows unauthenticated attackers to execute arbitrary code on vulnerable servers through specially crafted HTTP requests.

## Technical Details

### Root Cause

The vulnerability originates from insecure deserialization logic in the upstream React implementation (CVE-2025-55182) and affects Next.js applications using App Router. The issue lies in React Server Components' "Flight" protocol, which is responsible for serializing and deserializing data between server and client.

### Impact Scope

**Affected Next.js Versions:**
- Next.js 15.x
- Next.js 16.x
- Next.js 14.3.0-canary.77 and later canary releases

**Unaffected Versions:**
- Next.js 13.x
- Next.js 14.x stable releases
- Applications using Pages Router
- Edge Runtime

### Attack Vector

An attacker only needs to send a specially crafted HTTP request containing malicious RSC payload to the target server. When the server processes this payload, due to insecure deserialization logic, the attacker-controlled data can influence server-side execution flow, leading to arbitrary JavaScript code execution.

## Proof of Concept

### Disclaimer

**This tool is for educational purposes and security research only.** Do not use on unauthorized systems. Any illegal activities using this tool are unrelated to the author.

### Proof of Concept Script

`exploit.js` is a proof-of-concept script demonstrating how to construct and send malicious RSC payloads. This script includes the following functionalities:

1. **Generate Malicious Payload**: Construct RSC payloads that exploit the deserialization vulnerability
2. **Send Attack Requests**: Send malicious payloads to target servers
3. **Vulnerability Scanning**: Scan target applications for potentially vulnerable RSC endpoints

### Usage

#### Basic Usage

```bash
# Execute specific command
node exploit.js <target-url> <command>

# Example
node exploit.js http://localhost:3000 "whoami"
```

#### Scan Mode

```bash
# Scan target application for RSC endpoints
node exploit.js <target-url> --scan

# Example
node exploit.js http://localhost:3000 --scan
```

## Docker Demo Environment

To safely demonstrate and test this vulnerability, we provide a complete Docker demo environment containing a vulnerable Next.js application.

### Prerequisites

- Docker and Docker Compose
- At least 2GB free disk space
- At least 1GB free memory

### Quick Start

#### Method 1: Using Startup Script (Recommended)

**Windows (PowerShell):**
```powershell
.\setup-demo.ps1
```

**Linux/macOS:**
```bash
chmod +x setup-demo.sh
./setup-demo.sh
```

#### Method 2: Manual Start

```bash
# 1. Build Docker image
docker-compose build

# 2. Start container
docker-compose up -d

# 3. View logs (optional)
docker-compose logs -f
```

### Access Application

After starting, wait a few seconds, then access:

- **Application**: http://localhost:3000
- **RSC Endpoint**: http://localhost:3000/_rsc

### Test Vulnerability

Use the provided exploit script to test the vulnerability:

```bash
# Basic test
node exploit.js http://localhost:3000/_rsc "echo test"

# Execute command
node exploit.js http://localhost:3000/_rsc "whoami"

# Scan endpoints
node exploit.js http://localhost:3000 --scan
```

### Environment Information

The demo environment includes:

- **Next.js**: 15.0.4 (Vulnerable version)
- **React**: 19.0.0
- **Node.js**: 20 (Alpine Linux)
- **Architecture**: Uses App Router and Server Components

### Management Commands

```bash
# View logs
docker-compose logs -f

# Stop environment
docker-compose down

# Stop and remove data
docker-compose down -v

# Restart environment
docker-compose restart
```

### Security Notes

⚠️ **Important Warnings**:

1. **Educational Purpose Only**: This environment is for learning and security research only
2. **Isolated Environment**: Container runs in isolated network, but still be cautious
3. **Don't Expose to Internet**: Don't map ports to public IP
4. **Clean Up After Use**: Stop and remove containers after testing
5. **Don't Use in Production**: This configuration contains known security vulnerabilities

## Testing Tool

`test-vulnerability.js` is a tool for detecting whether an application is affected by this vulnerability. It performs the following checks:

1. **Version Check**: Verify if the Next.js version is within the affected range
2. **Endpoint Testing**: Check for potentially vulnerable RSC endpoints in the application
3. **Vulnerability Verification**: Test for the vulnerability using safe payloads

### Usage

```bash
# Test target application
node test-vulnerability.js <target-url>

# Example
node test-vulnerability.js http://localhost:3000
```

## Remediation

### Immediate Fix

1. **Upgrade Next.js**: Upgrade Next.js to the latest version, which includes a fix for this vulnerability

   ```bash
   npm install next@latest
   # or
   yarn upgrade next@latest
   # or
   pnpm update next@latest
   ```

2. **Verify Fix**: Use the `test-vulnerability.js` tool to verify the fix was successful

   ```bash
   node test-vulnerability.js <target-url>
   ```

### Temporary Mitigations

If an immediate upgrade is not possible, consider the following temporary mitigations:

1. **Use Pages Router**: Migrate affected routes to Pages Router, which is not affected by this vulnerability
2. **Enable Edge Runtime**: Enable Edge Runtime for affected routes, which is not affected by this vulnerability

   ```javascript
   // In page component or layout
   export const runtime = 'edge';
   ```

## Technical Details

### Vulnerability Mechanism

The vulnerability exploits insecure deserialization logic in React Server Components' "Flight" protocol. When a server receives an RSC request from a client, it deserializes the payload containing component data. Due to insufficient validation during deserialization, attackers can construct malicious payloads that cause the server to execute arbitrary JavaScript code.

### Exploitation Conditions

To exploit this vulnerability, an attacker needs to:

1. Target an application using Next.js 15.x, 16.x, or 14.3.0-canary.77 and later
2. Target an application using App Router
3. Be able to send HTTP requests to the target server

### Impact

Successful exploitation can lead to:

1. Remote Code Execution (RCE)
2. Full server control
3. Data exfiltration
4. Service disruption

## References

- [Next.js Security Announcements](https://nextjs.org/security)
- [React Server Components Documentation](https://react.dev/blog/2020/12/21/data-fetching-with-react-server-components)
- [CVE-2025-55182 Details](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-55182)