# FreePBX CVE-2025 Vulnerability Scanner

## ⚠️ DISCLAIMER

**FOR EDUCATIONAL AND AUTHORIZED TESTING ONLY**

- This tool is provided "AS IS" for educational and research purposes only
- Authors are NOT responsible for any misuse or illegal activities
- Unauthorized access to computer systems is ILLEGAL
- Only use on systems you own or have explicit written permission to test
- Users are solely responsible for compliance with all applicable laws

**BY USING THIS TOOL, YOU AGREE TO USE IT LEGALLY AND ETHICALLY.**

---

## 📖 Description

A security assessment tool for detecting critical vulnerabilities in FreePBX systems.

## 🔍 Vulnerabilities Covered

- **CVE-2025-66039**: Authentication Bypass (Webserver Auth)
- **CVE-2025-61675**: Authenticated SQL Injection
- **CVE-2025-61678**: Authenticated File Upload RCE

## ⚡ Features

- Authentication Bypass via PHPSESSID extraction
- File Upload RCE testing with path traversal
- SQL Injection detection across multiple endpoints
- Automated SQL exploitation
- Multi-threaded scanning
- Detailed reporting
- Debug mode with verbose output

## 📋 Requirements

- Python 3.6+
- See `requirements.txt` for dependencies

## 🚀 Installation

```bash
git clone https://github.com/BimBoxH4/CVE-2025-66039_CVE-2025-61675_CVE-2025-61678_reePBX.git
cd CVE-2025-66039_CVE-2025-61675_CVE-2025-61678_reePBX
pip3 install -r requirements.txt
```

## 💻 Usage

### Basic Examples

```bash
# Single target scan
python3 exploit.py -u http://target-ip

# Multiple targets with threads
python3 exploit.py -l targets.txt -t 10

# Debug mode
python3 exploit.py -u http://target-ip -d

# Save results
python3 exploit.py -l targets.txt -o results.txt
```

### Scan Modes

```bash
# All checks (default)
python3 exploit.py -u http://target-ip --mode all

# File upload only
python3 exploit.py -u http://target-ip --mode upload

# SQL injection only
python3 exploit.py -u http://target-ip --mode sql

# Auth bypass only
python3 exploit.py -u http://target-ip --mode auth
```

## 📝 Arguments

| Argument | Description |
|----------|-------------|
| `-u, --url` | Single target URL |
| `-l, --list` | File with target URLs (one per line) |
| `-t, --threads` | Number of threads (default: 1) |
| `-o, --output` | Output file for results |
| `-d, --debug` | Enable debug mode |
| `--mode` | Scan mode: all, upload, sql, auth |

## 📊 Scan Workflow

1. **Authentication Bypass** - Extract PHPSESSID cookie
2. **File Upload RCE** - Upload malicious PHP file
3. **SQL Injection** - Test and exploit multiple endpoints

## 🎯 Target File Format

```
http://192.168.1.100
http://192.168.1.101
https://freepbx.example.com
# Comments start with #
```

## 📄 Output Report

- Scan summary (total, vulnerable, safe)
- Vulnerability status per target
- PHPSESSID extraction results
- File upload success/failure
- SQL injection detection/exploitation
- Injected credentials

## 🛡️ Legal & Ethical Use

**Only use this tool if:**
- ✅ You own the system
- ✅ You have written authorization
- ✅ You follow responsible disclosure
- ✅ You comply with all laws

**Never:**
- ❌ Test without permission
- ❌ Access unauthorized systems
- ❌ Use for malicious purposes

## 🐛 Troubleshooting

- **SSL Errors**: SSL warnings are disabled by default
- **Timeouts**: Check network connectivity and target availability
- **No Vulnerabilities**: Verify target FreePBX version and try debug mode

## 📚 References

- CVE-2025-66039: Authentication Bypass
- CVE-2025-61675: SQL Injection
- CVE-2025-61678: File Upload RCE

---

**⚠️ REMEMBER: Unauthorized access is illegal. Use responsibly!**