# CVE-2025-65856

**Xiongmai XM530 IP Camera ONVIF Complete Authentication Bypass**

---

## Summary

Complete authentication bypass in the ONVIF implementation of Xiongmai XM530-series IP cameras allows unauthenticated remote access to sensitive device information, configuration, and video streams.

**CVE ID:** CVE-2025-65856  
**Severity:** CRITICAL  
**CVSS v3.1 Score:** 9.8 *(Researcher assessment - pending NVD analysis)*  
**CVSS Vector:** `CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H`

### CVSS Breakdown

* **Attack Vector (AV):** Network - Remotely exploitable
* **Attack Complexity (AC):** Low - No special conditions required
* **Privileges Required (PR):** None - No authentication needed
* **User Interaction (UI):** None - Zero-click exploitation
* **Confidentiality/Integrity/Availability:** High - Complete device compromise

*Official CVSS score will be published by NVD following their analysis.*   

---

## Affected Products

**Vendor:** Hangzhou Xiongmai Technology Co., Ltd.  
**Product:** IP Camera XM530V200_X6-WEQ_8M  
**Commercial Brand:** ANBIUX (and hundreds of OEM rebrands)  
**Firmware:** V5.00.R02.000807D8.10010.346624.S.ONVIF 21.06 and likely all V5.00.R02.* versions  
**Component:** ONVIF Web Service Implementation

**Device Context:**  
Xiongmai is a major OEM supplier of IP cameras sold under hundreds of brand names globally. These cameras are widely deployed in residential, commercial, and industrial surveillance systems.

---

## Vulnerability Details

The ONVIF web service implementation fails to enforce authentication on 31 critical endpoints that should require credentials per ONVIF specifications.

**Technical Details:**

1. **Missing WS-Security Authentication (CWE-306)**
   * ONVIF endpoints accept unauthenticated SOAP requests
   * No validation of Security headers
   * Standard ONVIF authentication completely bypassed

2. **Affected Endpoints (partial list):**
   * `GetDeviceInformation` - Hardware/firmware details
   * `GetUsers` - User account information
   * `GetStreamUri` - RTSP stream URIs with credentials
   * `GetSnapshotUri` - Still image URIs
   * `GetNetworkInterfaces` - Network configuration
   * `GetNetworkProtocols` - Enabled services/ports
   * `GetDNS` / `GetNTP` - DNS and NTP configuration
   * `GetPresets` / `GetNodes` - PTZ configuration
   * `SetRelayOutputState` - Control relay outputs (alarms)
   * ... and 22 additional critical endpoints

3. **Attack Surface:**
   * Common ports: 80, 8000, 8080, 8899
   * No rate limiting observed
   * Thousands of devices exposed to internet (Shodan: `port:80 "Server: uc-httpd"` or `port:8899 "XM"`)

---

## Impact

An unauthenticated remote attacker can:

* Access live video and audio streams
* Obtain complete device configuration
* Enumerate user accounts and credentials
* Control PTZ (Pan-Tilt-Zoom) functions
* Manipulate relay outputs (alarm systems)
* Perform network reconnaissance
* Extract RTSP credentials (see CVE-2025-65857)

**Privacy Impact:** Direct violation of GDPR and privacy regulations. Enables mass surveillance operations.

**Combined with CVE-2025-65857:** Complete zero-authentication access to live video streams.

---

## Proof of Concept

**Basic ONVIF Request (No Authentication):**

```bash
curl -X POST http://[CAMERA_IP]:8899/onvif/device_service \
  -H "Content-Type: application/soap+xml" \
  -d '<?xml version="1.0" encoding="UTF-8"?>
<s:Envelope xmlns:s="http://www.w3.org/2003/05/soap-envelope">
  <s:Body xmlns:tds="http://www.onvif.org/ver10/device/wsdl">
    <tds:GetDeviceInformation/>
  </s:Body>
</s:Envelope>'
```

**Expected:** Authentication required  
**Actual:** Full device information returned without credentials

Complete PoC testing all 31 vulnerable endpoints available to security researchers upon request.

---

## Mitigation

### For Users (Immediate):

* **Network Isolation:** Place cameras on isolated VLAN with no internet access
* **Firewall Rules:** Block inbound connections to ports 80, 8000, 8080, 8899, 554
* **Disable ONVIF:** Check camera settings for option to disable ONVIF protocol
* **VPN-Only Access:** Never expose cameras directly to internet
* **Consider Replacement:** Given vendor's security history, replacement recommended

### For Vendor:

* Implement proper WS-Security authentication on all ONVIF endpoints
* Follow ONVIF Core Specification security requirements
* Add rate limiting and brute force protection
* Enable security logging and alerts

**No patch currently available.**

---

## Timeline

* **November 2025:** Vulnerability discovered during security assessment
* **December 16, 2025:** CVE-2025-65856 assigned by MITRE   
* **December 17, 2025:** Vendor contact attempted via XMSRC@xiongmaitech.com (email delivery failed - server misconfigured)
* **December 17, 2025:** Alternative contact attempted via oversea_sales@xiongmaitech.com (email delivery failed)
* **December 17, 2025:** Public disclosure

**Vendor Response:** No response received. Official security contact infrastructure non-functional.

---

## Credits

**Discovered by:** Luis Miranda Acebedo  
**Location:** Vigo, Galicia, Spain  
**Contact:** luis.miranda.acebedo@gmail.com

---

## References

* **CVE:** https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-65856
* **Related:** CVE-2025-65857 (Hardcoded RTSP Credentials)
* **CWE-306:** https://cwe.mitre.org/data/definitions/306.html
* **ONVIF Spec:** https://www.onvif.org/specs/core/ONVIF-Core-Specification.pdf
* **Vendor History:**
  * CVE-2017-16725 (Directory traversal, unpatched)
  * CVE-2018-10088 (Authentication bypass, unpatched)
  * CVE-2018-17915, 17917, 17919 (XMEye P2P vulnerabilities)
  * Mirai botnet contributor (2016)
  * SEC Consult Advisory (2018): "Recommend discontinuing Xiongmai products"

This site is open source. [Improve this page](https://github.com/LuisMirandaAcebedo/CVE-2025-65856/edit/main/README.md).
