# CVE-2025-65855

**HelpFlash IoT OTA Update Multiple Vulnerabilities**

---

## Summary

Multiple vulnerabilities in the OTA firmware update mechanism of Netun Solutions HelpFlash IoT allow an attacker with brief physical access to execute arbitrary code.

**CVE ID:** CVE-2025-65855  
**Severity:** HIGH  
**CVSS v3.1 Score:** 7.6 *(Researcher assessment - pending NVD analysis)*  
**CVSS Vector:** `CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H`

### CVSS Breakdown
- **Attack Vector (AV):** Physical - Brief physical access (~10 seconds)
- **Attack Complexity (AC):** Low - Hard-coded credentials enable straightforward attack
- **Privileges Required (PR):** None
- **User Interaction (UI):** Required - Button press to activate OTA mode
- **Confidentiality/Integrity/Availability:** High - Complete device compromise

*Official CVSS score will be published by NVD following their analysis.*

---

## Affected Products

**Vendor:** Netun Solutions S.L.  
**Product:** HelpFlash IoT  
**Product Page:** https://netun.com/en/products/help-flash-iot   
**Versions:** v18_178_221102_ASCII_PRO_1R5_50 and prior  
**Component:** OTA firmware update system (ESP-IDF v4.3.2)

**Device Context:**   
HelpFlash IoT is a safety-critical emergency road signaling device mandated by Spanish traffic authority (DGT) as a replacement for traditional warning triangles in vehicles.

---

## Vulnerability Details

The device's OTA update mechanism contains multiple security issues:

1. **Hard-coded WiFi Credentials (CWE-798)**
   - Credentials identical across all devices
   - SSID: `HF-UpdateAP-5JvqFV`
   - Password: `HF-UpdateAP-5JvqFV`

2. **Unauthenticated Update Server (CWE-494)**
   - No server authentication
   - No firmware signature verification
   - HTTP only (no HTTPS)

3. **Cleartext Transmission (CWE-319)**
   - Firmware transmitted over unencrypted HTTP
   - Vulnerable to MITM attacks

4. **No OTA Activation Authentication**
   - 8-second button press activates OTA mode
   - No PIN or additional authentication required

---

## Impact

An attacker with brief physical access can:
- Create malicious WiFi AP using known credentials
- Serve malicious firmware via HTTP
- Achieve arbitrary code execution
- Compromise safety-critical emergency device

**Attack Scalability:** Identical credentials across all devices enable mass exploitation.

---

## Proof of Concept

Complete proof of concept developed and validated on multiple devices. Attack successfully demonstrated:
- Malicious WiFi AP connection
- Firmware download and installation
- Arbitrary code execution

PoC code available to vendor and security researchers under appropriate arrangements.

---

## Mitigation

Vendor should implement:
- Unique WiFi credentials per device
- HTTPS with certificate pinning
- Firmware digital signatures
- User authentication for OTA mode

---

## Timeline

- **November 3, 2025:** Vulnerability discovered and reported to INCIBE-CERT
- **November 11, 2025:** INCIBE-CERT declined CVE assignment, authorized public disclosure
- **November 14, 2025:** Submitted to MITRE CVE Program
- **December 16, 2025:** CVE-2025-65855 assigned by MITRE
- **December 2025:** Public disclosure

*Vendor was notified through INCIBE-CERT coordinated disclosure process. INCIBE-CERT confirmed no publication restrictions apply and authorized public disclosure.*

---

## Credits

**Discovered by:** Luis Miranda Acebedo  
**Contact:** luis.miranda.acebedo@gmail.com

---

## References

- **CVE:** https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-65855
- **CWE-494:** https://cwe.mitre.org/data/definitions/494.html
- **CWE-319:** https://cwe.mitre.org/data/definitions/319.html
- **CWE-798:** https://cwe.mitre.org/data/definitions/798.html


