# CVE-2025-65791 — Command Injection in ZoneMinder

## Overview
A critical **Command Injection** vulnerability exists in **ZoneMinder v1.36.34** due to improper input validation in the `web/views/image.php` component. Unsanitized user-controlled input is passed directly to the PHP `exec()` function, allowing remote attackers to execute arbitrary system commands.

This vulnerability has been assigned **CVE-2025-65791**.

---

## Affected Product
- **Vendor:** ZoneMinder  
- **Product:** ZoneMinder  
- **Version:** 1.36.34  
- **Component:** `web/views/image.php`

---

## Vulnerability Details
The application fails to properly sanitize user-supplied input before using it within shell commands. Parameters processed in `image.php` are passed directly to the `exec()` function, enabling attackers to inject shell metacharacters and execute arbitrary commands on the underlying operating system.

This vulnerability may be exploited remotely and does not require authentication in certain configurations.

---

## Vulnerability Classification
- **CWE:** CWE-78 — Improper Neutralization of Special Elements used in an OS Command  
- **Vulnerability Type:** Command Injection  
- **Attack Type:** Remote  
- **Impact:** Arbitrary Command Execution  

---

## Attack Scenarios
An attacker may leverage this vulnerability to:
- Execute arbitrary operating system commands
- Read, modify, or delete sensitive files
- Establish a reverse shell
- Escalate privileges depending on service permissions
- Fully compromise the affected server

---

## Proof of Concept (PoC)

> ⚠️ **Warning:** For educational and authorized testing purposes only.


?when=now;id

This payload appends a malicious command to the intended command execution flow, resulting in arbitrary command execution.

---

## Impact Assessment

| Impact Area       | Severity |
|-------------------|----------|
| Confidentiality   | High     |
| Integrity         | High     |
| Availability      | High     |

This vulnerability qualifies as **critical severity (P1)** due to the possibility of unauthenticated remote code execution.

---

## Mitigation Recommendations

- Avoid using `exec()` with user-controlled input
- Implement strict input validation and allowlists
- Use safe system call wrappers (e.g., `escapeshellarg()`)
- Apply vendor patches once available
- Restrict web service privileges using least-privilege principles

---

## References

- CWE-78: https://cwe.mitre.org/data/definitions/78.html  
- CVE ID: **CVE-2025-65791** (Assigned, pending publication)

---

## Disclosure Timeline

- **Discovery:** 2025  
- **CVE Assigned:** 2025  
- **Public Disclosure:** Pending  

---

## Discoverer

**Rishav Anand**

---

## Disclaimer

This information is provided for educational and defensive security purposes only. The author takes no responsibility for misuse of the information provided.

