# CVE-2025-65731
## CWE-1191: On-Chip Debug and Test Interface With Improper Access Control
### UART Root Shell Access on D-Link DIR-605L (Hardware F1, Firmware V6.02CN02)
<img width="979" height="1213" alt="1" src="https://github.com/user-attachments/assets/ff5a5c81-0a44-4329-bbc2-df8a3108e409" />

### Summary
A critical hardware security vulnerability has been identified in the D-Link DIR-605L router, Hardware Version F1, Firmware External Version V6.02CN02, running Linux kernel 2.4.18. The UART debug interface lacks proper access control mechanisms, allowing any attacker with physical access to connect to the UART pins and gain unauthenticated root shell access. This vulnerability corresponds to CWE-1191: On-Chip Debug and Test Interface With Improper Access Control.

### Affected Product:
Device Model: D-Link DIR-605L - Firmware Version: V6.02CN02

### Vulnerability Description
The UART debug interface, exposed physically via device pins, is accessible without any authentication or authorization barriers. An attacker connecting to these UART pins can instantly access the device's root shell during or after boot, bypassing all software-based authentication controls. This direct root shell access compromises the confidentiality, integrity, and availability of the entire device and its network environment.

### Impact:
Full root-level control of the router with no authentication required.
Ability to modify device configuration, install persistent malware, or intercept network traffic.
Complete circumvention of on-device security mechanisms.
Potential pivot point for attacks on the connected network and devices.

### Proof of Concept:
1. The UART pins on the D-Link DIR-605L (Hardware F1) were identified and connected to a serial interface.
<img width="729" height="321" alt="2" src="https://github.com/user-attachments/assets/fe3b9252-83e7-415e-b464-7cf5a0482740" />

2. Using a serial terminal emulator at the appropriate baud rate, the device’s bootloader output and Linux shell prompt were accessed.
<img width="655" height="346" alt="3" src="https://github.com/user-attachments/assets/3f7ebcdc-2f41-489f-af63-066a2c1c05b7" />

3. Commands such as cat /etc/passwd confirmed root user presence without password protection on this interface.
<img width="490" height="266" alt="4" src="https://github.com/user-attachments/assets/c34acd76-9288-4596-8477-d6b90088e7a2" />

4. A fully interactive root shell prompt (#) was obtained, enabling arbitrary command execution on the device.
<img width="480" height="205" alt="5" src="https://github.com/user-attachments/assets/4de68782-a683-4029-8110-91d93639f71f" />

### References:
CWE-1191: https://cwe.mitre.org/data/definitions/1191.html

## Author:
Mohamed Danish (j3rry)
