# CVE-2025-6554

## Reproducing the Vulnerability
```setup
for macOS:
brew intsall ninja

git clone https://chromium.googlesource.com/chromium/tools/depot_tools.git
export PATH=/path/to/depot_tools:$PATH

fetch v8
cd v8
git checkout 13.8.500258
gclient sync -D
sh v8asan.sh
autoninja -C out/arm64.asan d8
ASAN_OPTIONS=detect_leaks=1:halt_on_error=0 ./d8 --allow-natives-syntax --trace-opt --trace-deopt poc-CVE-2025-6554.js

for linux:
apt-get update && apt-get install -y git python3 g++ make gdb wget curl

git clone https://chromium.googlesource.com/chromium/tools/depot_tools.git
export PATH="/root/depot_tools:${PATH}"

mkdir -p /root/v8_build_sandbox
cd /root/v8_build_sandbox
fetch v8
cd v8
git checkout 13.8.500258
gclient sync -D
tools/dev/v8gen.py x64.debug.asan
ninja -C out.gn/x64.debug.asan d8
mkdir -p /root/v8_tests
ASAN_OPTIONS=detect_leaks=1:halt_on_error=0 /root/v8_build_sandbox/v8/out.gn/x64.debug.asan/d8 --allow-natives-syntax --trace-opt --trace-deopt /root/v8_tests/poc-CVE-2025-6554.js
```
