# CVE-2025-65300

[Description]

CVE-2025-65300: Stored Cross-Site Scripting (XSS) Vulnerability in Coohom SaaS Platform

Disclosure Date: 2025-10-28
Last Updated: 2025-10-28
Reporter: Phisit Pupiw
Vendor: Coohom
CWE: CWE-79 – Cross-Site Scripting

------------------------------------------

[Summary]

A stored Cross-Site Scripting (XSS) vulnerability was identified in the Coohom SaaS Platform within the Account Settings → Profile → Address module. User-supplied input stored in the City, State, and Country/Region fields is rendered back to the client without proper sanitization or context-aware output encoding.
This allows attackers to store malicious JavaScript payloads that execute whenever the affected profile area is viewed.
The issue affects production build feVersion=1760060603897 (verified on 2025-10-28).

------------------------------------------

[Vulnerability Details]

The frontend renders user data directly from "window.SAAS_ENV.userInfo.{city, state, country}" without sanitization or escaping, causing stored XSS when injected payloads are stored in the database and later displayed in the UI.
Example Malicious Payload "</script><script>alert(document.cookie)</script>" When this payload is entered into the City field, saved, and the profile page is reloaded, arbitrary JavaScript executes in the victim’s browser.

------------------------------------------

[Affected Components]

Module: Account Settings → Profile → Address fields
Fields: city, state, country
Frontend Build Affected: feVersion=1760060603897
Production URL: https://www.coohom.com/pub/saas/settings/account

------------------------------------------

[Impact]

An attacker can perform the following:
- Execute arbitrary JavaScript in the victim’s browser
- Steal session cookies (subject to browser protections)
- Perform actions on behalf of the victim
- Redirect users or inject malicious content
- Persist malicious scripts affecting all future views

------------------------------------------

[Attack Vector]

- Access Required: Authenticated user
- Attack Type: Remote
- User Interaction: Viewing affected profile page

------------------------------------------

[Attack Flow]

1. Attacker signs in or registers a Coohom account
2. Navigates to Account Settings → Profile → Address
3. Inserts malicious payload into City, State, or Country/Region
4. Saves the form
5. Script executes whenever the profile section is rendered

------------------------------------------

[Proof of Concept (PoC)]

Steps to Reproduce
1. Login to Coohom (https://www.coohom.com)
2. Open Account Settings → Profile → Address
3. Input the payload below into the City field "</script><script>alert(document.cookie)</script>"
4. Save and refresh the page
5. JavaScript executes immediately → confirming stored 

------------------------------------------

[Recommendation]

- Sanitize input on save
- Reject HTML tags and dangerous attributes
- HTML-encode
- JavaScript-encode
- Attribute-encode
- Implement Content-Security-Policy (CSP)
- Disable inline scripts with script-src 'self'

------------------------------------------

[References]

- https://www.coohom.com/pub/saas/settings/account
- CVE record status (MITRE): CVE-2025-65300 (RESERVED)

------------------------------------------

[Credits]

Discovered by : Phisit Pupiw
