# CVE-2025-64513 – Milvus Proxy Authentication Bypass Vulnerability PoC

## 📘 Overview

This repository contains a **proof-of-concept (PoC)** script to verify the existence of **CVE-2025-64513**,
a critical **authentication bypass vulnerability** in **Milvus Proxy** that may allow unauthorized access to internal APIs.

When an unauthenticated request is sent with a crafted `sourceid` header, some Milvus versions fail to enforce identity checks, resulting in potential **full unauthenticated access** to the database metadata and collection information.

> ⚠️ This PoC is for **security research and defensive validation only**.
> Do **not** use it on systems without explicit authorization.

---

## 🚨 Affected Versions

According to current analysis, the following Milvus versions are affected:

| Version Range    | Status     |
| ---------------- | ---------- |
| `< 2.4.24`       | Vulnerable |
| `2.5.* < 2.5.21` | Vulnerable |
| `2.6.* < 2.6.5`  | Vulnerable |

Later versions are expected to include authentication enforcement fixes.

---

## 🧰 Features

* Detects unauthenticated Milvus Proxy access.
* Collects detailed system information:

  * Milvus **version**
  * **Health status** (`GetMetrics`)
  * **Database count and names**
  * **Collection count** per database
* Supports **batch scanning** from file input.
* **Multi-threaded** for faster verification.

---

## ⚙️ Usage

### 1️⃣ Installation

```bash
git clone https://github.com/<yourname>/CVE-2025-64513-POC.git
cd CVE-2025-64513-POC
pip install -r requirements.txt
```

`requirements.txt` should include:

```
grpcio
pymilvus
```

---

### 2️⃣ Prepare Targets File

Create a text file (e.g. `targets.txt`):

```
192.168.1.10:19530
milvus.example.com:19530
```

Lines starting with `#` are ignored.

---

### 3️⃣ Run PoC

```bash
python3 check_cve_2025_64513.py targets.txt
```

---

## 🧾 Example Output

```
Starting scan for 2 targets ...

[+] 192.168.1.10:19530 is vulnerable to unauthorized access
[Version] 2.5.10
[Health] Healthy
[Database Count] 2
[Databases] ['default', 'analytics']
[Collections per Database] {'default': ['users', 'products'], 'analytics': ['events']}

[-] milvus.example.com:19530 not vulnerable (RPC failed: UNAVAILABLE)

```

---

## 🛡️ Mitigation

* Upgrade to the latest Milvus version (`>= 2.6.5` recommended).
* Restrict access to port `19530` using firewall or reverse proxy.
* Enforce authentication and TLS for all external access.

---

## 📚 References

* [CVE-2025-64513 – NVD Listing (pending)](https://nvd.nist.gov/)
* [Milvus Official Website](https://milvus.io)
* [Milvus GitHub Repository](https://github.com/milvus-io/milvus)

---

## ⚠️ Legal Disclaimer

This project is intended **solely for educational and defensive research purposes**.
Running this PoC against systems without authorization is **illegal**.
The author and contributors **assume no liability** for misuse or damage caused by this code.

