# 🔐 CVE-2025-64484 — OAuth2-Proxy Header Normalization Vulnerability

<img width="1200" height="589" alt="G5zy5OwbkAExGgS" src="https://github.com/user-attachments/assets/60775348-6781-40d6-8e2b-edb85d8fe2fb" />

### 🧩 **What Is It?**

A **High-severity** vulnerability in **OAuth2-Proxy** (versions **< 7.13.0**) caused by inconsistent treatment of header names that use:

* `-` dashes
* `_` underscores

Attackers can sneak malicious headers through by switching dashes ↔ underscores.
This may bypass intended protections 🚨

---

## ⚠️ **Why It Matters**

* **Severity:** 🔥 **CVSS 8.5** (High)
* **Who’s affected:** Any service using OAuth2-Proxy in front of an app that *normalizes underscores and dashes* (e.g., Django, Flask, PHP apps).
* **Risk:**

  * 🆔 Identity spoofing
  * 🔓 Privilege escalation
  * 🎭 Manipulating trusted “forwarded” headers

OAuth2-Proxy itself isn’t “broken” — but it can unintentionally pass attacker-controlled headers to upstream apps.

---

## 🛡️ **How to Fix It**

### ✅ **1. Upgrade**

Update to **OAuth2-Proxy 7.13.0 or later** ✔️
This fully patches the issue.

### 🧰 **2. Temporary Mitigations** (if you cannot upgrade)

* Ensure your upstream app **does not treat `_` and `-` as equivalent**
* Add strict header filtering or normalization rules
* Use new config option `InsecureSkipHeaderNormalization` carefully 🔧

---

### How to Use CVE-2025-64484.py

#### 1. Save the file

```bash
sudo git clone https://github.com/B1ack4sh/Blackash-CVE-2025-64484.git
chmod +x CVE-2025-64484.py
```

#### 2. Run Against Your Vulnerable Lab (port 4180)

```
python3 CVE-2025-64484.py http://localhost:4180/
```

#### 3. Run Against Patched (port 4181)

```
python3 CVE-2025-64484.py http://localhost:4181/
```

**Expected Output**
Vulnerable (v7.12.0)

```
[+] Status: 200
🎯 [EXPLOIT SUCCESS] Authenticated as: admin@pwned.local
```

Patched (v7.13.0)

```
[-] Exploit failed. Header not reflected.
```

---

## 🔍 **Technical Insight (Simplified)**

Think of it like this:

🔐 **OAuth2-Proxy blocks dangerous headers**
but
🎭 **Attacker renames them using `_` instead of `-`**
and
📨 **The backend silently changes `_` → `-` — restoring the dangerous header**

Result: A sneaky bypass. 😈

---

## ⚠️ Disclaimer !!!

Educational use **only**. Test **solely on systems you own**. **Never** use on production, third-party, or unauthorized targets. **You** are responsible for compliance.
